function rmind = find_overlap (lonfne,dlonfne,latfne,dlatfne,loncrs,latcrs);
%
% function rmind = find_overlap (lonfne,dlonfne,latfne,dlatfne,loncrs,latcrs);
%
% This function finds the indices of overlapping climatology between coarse
% and fine grids and returns the locations of the overlapping coarse nodes.
%
% ------
% Input:
% ------
%
%    LONFNE    Fine grid data longitudes.
%    DLONFNE   Fine grid longitudinal spacing.
%    LATFNE    Fine grid data latitudes.
%    DLATFNE   Fine grid latitudinal spacing.
%    LONCRS    Coarse grid data longitudes.
%    LATCRS    Coarse grid data latitudes.
%
% -------
% Output:
% -------
%
%    RMIND     Indices of coarse data overlap.

%-------------------------------------------------------------------------------
% Initialize output.
%-------------------------------------------------------------------------------

rmind  = [];
dlonlm = dlonfne.*0.5;
dlatlm = dlatfne.*0.5;

%-------------------------------------------------------------------------------
% Examine coarse grid for data overlap.
%-------------------------------------------------------------------------------

for n = 1:length(loncrs(:))

    dlon = abs(lonfne(:) - loncrs(n));
    dlat = abs(latfne(:) - latcrs(n));

    if (length(find((dlon<=dlonlm) & (dlat<=dlatlm))) >= 2)
       rmind = [rmind n];
    end;

end;
