function stamp = pjh_greg (julian);
%
% function stamp = pjh_greg (julian);
%
% This function converts a modified Julian time into a GRIDS type date stamp.
%
% Input:
%
%    julian...decimal modified Julian day number
%
% Output:
%
%    stamp....Date/time stamp of the form:
%             day of week - month day, year - time
%

%-------------------------------------------------------------------------------
% Define string arrays for day of the week and month.
%-------------------------------------------------------------------------------

wkday = ['Sunday   ';'Monday   ';'Tuesday  ';'Wednesday';'Thursday ';...
         'Friday   ';'Saturday '];
lwkday = [6,6,7,9,8,6,8];

month = ['January  ';'February ';'March    ';'April    ';'May      ';...
         'June     ';'July     ';'August   ';'September';'October  ';...
         'November ';'December '];
lmonth = [7,8,5,5,3,4,4,6,9,7,8,8];

ampm = ['am';'pm'];

%-------------------------------------------------------------------------------
% Get date and time information.
%-------------------------------------------------------------------------------

date_info=gregorian(julian+2440000);

year = date_info(:,1);
imonth = date_info(:,2);
day = date_info(:,3);
hour = date_info(:,4);
minute = date_info(:,5);
second = date_info(:,6);

%-------------------------------------------------------------------------------
% Reset hour to 12-hour clock.
%-------------------------------------------------------------------------------

half = rem( fix(hour/12),2) + 1;

hour = rem( hour, 12);
ind = find (hour==0);
if (~isempty(ind)), hour(ind) = 12.*ones(size(ind)); end;

%-------------------------------------------------------------------------------
% Get day of the week code.
%-------------------------------------------------------------------------------

nday = max(size(year));

for n = 1:nday
   iwday(n) = day_code(imonth(n),day(n),year(n));
end;

%-------------------------------------------------------------------------------
% Set date stamp.
%-------------------------------------------------------------------------------

for n = 1:nday
   if (minute(n)>=10),
      cmin = num2str(minute(n));
     else
      cmin = ['0',num2str(minute(n))];
   end;
   if (second(n)>=10),
      csec = num2str(second(n));
     else
      csec = ['0',num2str(second(n))];
   end;
   work = [wkday(iwday(n),1:lwkday(iwday(n))),' - ',...
           month(imonth(n),1:lmonth(imonth(n))),...
           ' ',num2str(day(n)),', ',num2str(year(n)),...
           ' - ',num2str(hour(n)),':',cmin,':',csec,ampm(half(n),:)];
   len = max(size(work));
   stamp(n,1:len) = work;
end;
