% show_pden
%
% This script produces plots of potential
% density to aid in designing sigma
% surfaces for HydroBase averaging.

%-------------------------------------------------------------------------------
% Set run parameters
%
%    p_ref....Set of reference pressures
%    hydnam...Name of hydrographic data file in MODS format.
%-------------------------------------------------------------------------------

%-----------------------
%hydnam  = '7305.mods';
%p_ref = 0:1000:5000;
%-----------------------
%hydnam  = '7306.mods';
%p_ref = 0;
%p_ref = 0:1000:5000;
%-----------------------
%hydnam  = '7307.mods';
%p_ref = 0:1000:2000;
%p_ref = 0:1000:5000;
%-----------------------
%hydnam  = '7405.mods';
%p_ref = 0:1000:5000;
%-----------------------
%hydnam  = '7406.mods';
%p_ref = 0;
%p_ref = 0:1000:5000;
%-----------------------
hydnam  = '7407.mods';
p_ref = 0;
%-----------------------

%-------------------------------------------------------------------------------
% Set useful constants
%-------------------------------------------------------------------------------

fillnan = 1;

verstr = version;

%-------------------------------------------------------------------------------
% Read in the data.
%-------------------------------------------------------------------------------

[header,hinfo,htype,z,t,s] = rhydro (hydnam,fillnan);

hlat = hinfo(:,5);

%---------------------
%--- Extract title ---
%---------------------

ttlline = header (1,:);

ind    = find (ttlline=='=');
remind = 1:ind(1);
if ~isempty(remind),
   ttlline(remind) = [];
end;

ind    = min(find(ttlline~=' '));
remind = 1:(ind-1);
if ~isempty(remind),
   ttlline(remind) = [];
end;

nmax   = max(size(ttlline));
ind    = max(find( (ttlline~=' ') & (abs(ttlline)~=0) ));
remind = (ind+1):nmax;
if ~isempty(remind),
   ttlline(remind) = [];
end;

clear header hinfo htype fillnan nmax;

%-------------------------------------------
%--- Find sizes, create latitude matrix. ---
%-------------------------------------------

[nprof npt] = size(z);

lat = hlat*ones(1,npt);

clear hlat;

%-------------------------------------------------------------------------------
% Loop over all reference pressures, producing the plots.
%-------------------------------------------------------------------------------

no_press = length(p_ref);

npx = fix(sqrt(no_press));
npy = npx;
if (npx*npy<no_press)
   npx = npx + 1;
   if (npx*npy<no_press)
     npy = npy + 1;
   end;
end;

for np = 1:no_press,

   %--------------------------------------
   %--- Determine desired depth range. ---
   %--------------------------------------

   zrng  = [(-p_ref(np)-500) min([(-p_ref(np)+500) 0])];

   %----------------------------------
   %--- Compute potential density. ---
   %----------------------------------

   ind   = find ( ~isnan(z) & (-z>=zrng(1)) & (-z<=zrng(2)) );
   press = NaN.*ones(nprof,npt);
   pden  = press;

   if ~isempty(ind)
      press = sw_pres (z,lat);

      ind       = find (~isnan(z) & ~isnan(t) & ~isnan(s) & (-z>=zrng(1)) & ...
                                                         (-z<=zrng(2)) );
      if ~isempty(ind)
         pden = sw_pden (s,t,press,p_ref(np)) - 1000;
      end;
   end;

   %---------------------
   %--- Plot results. ---
   %---------------------

   if any(~isnan(pden(:)))
      subplot(npy,npx,np);
      plot   (pden',-z','k');
      if (diff(extrem(pden(ind)))>0)
         set (gca,'XLim',extrem(pden(ind)),'YLim',zrng,'FontName','Times');
       else
         set (gca,'YLim',zrng,'FontName','Times');
      end;
      if (str2num(verstr(1))<5),
        xlabel ('Potential Density Anomaly  (kg/m^3)');
       else
        set    (gca,'FontSize',14);
        xlabel ('\sigma_\theta  (kg/m^3)');
      end;
      ylabel ('Depth  (m)'); ...
      title  (['ref ',num2str(p_ref(np)),'db']); ...
      grid on;
   end;

end;

h = suptitle (hydnam);
set (h,'FontName','Times','FontSize',14);

clear h hydnam ind nprof npt;
