% no_overlap_climos
%
% This script produces an interlocking set of climatologies without overlaps.

%-------------------------------------------------------------------------------
% Set run parameters.
%-------------------------------------------------------------------------------

fnefiles = 'june_nwash_p125_5.mods';

fneres = 0.125;

crsins = ['june_nwash_p25_5.mods'; ...
          'june_nwash_p5_5.mods '; ...
          'june_nwash_c1_5.mods '];

crsres = [0.25 0.5 1.0];

crsouts = ['june_nwash_p25_5_noov.mods'; ...
           'june_nwash_p5_5_noov.mods '; ...
           'june_nwash_c1_5_noov.mods '];

%---------------------------------------

%fnefiles = 'june_nwadp_p25_5.mods';

%fneres = 0.25;

%crsins = ['june_nwadp_p5_5.mods'; ...
%          'june_nwadp_c1_5.mods'; ...
%          'june_nwadp_c2_5.mods'];

%crsres = [0.5 1.0 2.0];

%crsouts = ['june_nwadp_p5_5_noov.mods'; ...
%           'june_nwadp_c1_5_noov.mods'; ...
%           'june_nwadp_c2_5_noov.mods'];

%-------------------------------------------------------------------------------
% Remove overlapping data.
%-------------------------------------------------------------------------------

for n = 1:length(crsres);

   %---------------------------------------------------------
   %--- Remove overlapping data from current coarse file. ---
   %---------------------------------------------------------

   inind  = find (~isspace(crsins(n,:)));
   outind = find (~isspace(crsouts(n,:)));

   status = rm_ovrlp (fnefiles,fneres,crsins(n,inind),crsouts(n,outind));

   %----------------------------
   %--- Increment fine list. ---
   %----------------------------

   if (status==0)
      fnefiles = strvcat (fnefiles, crsouts(n,outind) );
      fneres   = [fneres, crsres(n)];
      disp (['   Eliminated overlap from ',crsins(n,inind)]);
    elseif (status==1)
      fnefiles = strvcat (fnefiles, crsins(n,inind) );
      fneres   = [fneres, crsres(n)];
      disp (['   No overlap from ',crsins(n,inind)]);
    elseif (status==2)
      disp (['   Eliminated ',crsins(n,inind)]);
    else
      disp (['   Unable to create ',crsouts(n,outind)]);
   end;

end;

clear fnefiles fneres crsins crsres crsouts n inind outind status;
