/*  getpos.c
................................................................................
.  Extracts the lat, lon from HydroBase data files and writes it out to 
.  the stdout device.
.
................................................................................
*/

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include "hydrobase.h"


#define    EXTENT    ""
#define    DIR       ""
#define    PRINT_MSG  1               /* 0 or 1 */

main (argc, argv)
int   argc;
char *argv[];
{
   int     i, nfiles = 0, curfile = 1; 
   int     error, status, infile;
   short   bopt;
   float  xmin, xmax, ymin, ymax;
   int     xdateline;
   char   *dir, *extent, *st;
   struct HYDRO_HDR hdr;
   struct HYDRO_DATA data;
   void print_usage(), report_status();


/* are there command line arguments? */

   if (argc < 2) {
      print_usage(argv[0]);
      exit(1);
   }

/*  set these default values */

    dir = DIR;
    extent = EXTENT;
    bopt = 0;
    error = 0;
    xdateline = 0;


/* parse command line arguments... */

   for (i = 1; i < argc; i++) {
      if (argv[i][0] == '-') {
            switch (argv[i][1]) {
               case 'D':
                        dir = &argv[i][2];
                        break;
               case 'E':
                        extent = &argv[i][2];
                        break;

               case 'B':                    /* get grid bounds */
                        bopt = 1;
                        st = &argv[i][2];
                           if (*st == '/')
                               ++st;
                        error = (sscanf(st,"%f", &xmin) != 1);
                        while (*(st++) != '/')
                           ;  
                        error += (sscanf(st,"%f", &xmax) != 1);
                        while (*(st++) != '/')
                           ;  
                        error += (sscanf(st,"%f", &ymin) != 1);
                        while (*(st++) != '/')
                           ;  
                        error += (sscanf(st,"%f", &ymax) != 1);
                        if (xmin > 0 && xmax < 0)
                           xmax += 360;
                        if (xmax > 180)
                           xdateline = 1;
                        break;
               default :
                        print_usage(argv[0]);
                        fprintf(stderr,"\nError parsing command line");
                        fprintf(stderr,"\n in particular: %s\n", argv[i]);
                        exit(1);
            }  /* end switch */

            if (error ) {
                print_usage(argv[0]);
                fprintf(stderr,"\nError parsing command line args.\n");
                fprintf(stderr,"     in particular: '%s'\n", argv[i]);
                exit(1);
            }
            
       }  /* end if */
       else  {
           ++nfiles;
       }
   }  /* end for */

   if ( !nfiles) {
       print_usage(argv[0]);
       fprintf(stderr,"\n\nYou must specify input file(s)!\n");
       exit(1);
   }



/* loop for each file */

   do {
      infile = open_hydro_file(dir, argv[curfile], extent, PRINT_MSG);
      if (infile  < 0) 
       goto NEXTFILE;

     /* loop for each station */

     while ((status = get_station(infile, &hdr, &data)) == 0) { 
 
       if (xdateline && hdr.lon < 0)
          hdr.lon += 360;
          
       if (bopt) {
          if ((hdr.lon <= xmax) && (hdr.lon >= xmin) && 
           (hdr.lat <= ymax) && (hdr.lat >= ymin) )  
             fprintf(stdout, "%8.3f %8.3f\n", hdr.lon, hdr.lat);
       }
       else 
             fprintf(stdout, "%8.3f %8.3f\n", hdr.lon, hdr.lat);

     }  /* end while */ 

     report_status(status, stderr);
     close(infile);

NEXTFILE:
      ;
   } while (curfile++ < nfiles);

   fprintf(stderr,"\n\n End of getpos. \n");
   exit(0);

}  /* end of main() */

/****************************************************************************/

void print_usage(program)
char *program;
{
   fprintf(stderr,"\nUsage:  %s list_of_filenames", program);

   fprintf(stderr," [-Ddirname] [-Eextent] [-Bminlon/maxlon/minlat/maxlat]");
   fprintf(stderr,"\n    -D  : specifies directory of input files (default is ./) ");
   fprintf(stderr,"\n        ex: -D../data/ ");
   fprintf(stderr,"\n    -E  : specifies input_file extent (default is no extent)");  
   fprintf(stderr,"\n        ex: -E.dat ");
   fprintf(stderr,"\n    -B  : specifies optional boundaries.");
   fprintf(stderr,"\n        ex: -B-90/0/0/65 ");
   fprintf(stderr,"\n\n");  
   return;
}

