/*   hydro_cdf.h
.
.  Contains the definition for netcdf files used with hydro database.
.
*/

#define COUNT_VAR_SUFFIX  "_cnt"   /* nomenclature for count variables */


    /****************************************************************/

#define    MAXSTDLEVS  100     /* max # of standard depth levels */
double std_depth[MAXSTDLEVS];  /* initialize this with std_depth_init()  */
int  NSTDLEVS ;                /* actual number of standard depth levels to be
                                  set in std_depth_init() */

int  std_depth_initialized;    /* set this to 1 after initializing */

    /****************************************************************/

struct CDF_HDR {
    int nx;             /* Number of columns */
    int ny;             /* Number of rows */
    int nz;             /* Number of depth levels */
    int nt;             /* Number of time bins */
    int nprops;         /* Number of properties */
    int counts_included; /* 1/0= counts for each property are included or not */
    int node_offset;    /* 0 for node grids, 1 for pixel grids */
    float fill_value;   /* to denote missing data */
    float xmin;         /* Minimum x coordinate */
    float xmax;         /* Maximum x coordinate */
    float ymin;         /* Minimum y coordinate */
    float ymax;         /* Maximum y coordinate */
    float xincr;        /* x increment */
    float yincr;        /* y increment */
    int *tmin;          /* min year for each time bin */
    int *tmax;          /* max year for each time bin */
    char x_units[80];   /* units in x-direction */
    char y_units[80];   /* units in y-direction */
    char z_units[80];   /* units in z-direction */
    char t_units[80];   /* units in time dimension */
    char **prop_id;     /* 2-char mnemonic of various properties */
    char **prop_units;  /* units of various properties */
    char title[80];     /* name of data set */
    char command[320];  /* name of generating command */
};

   /*  Description of node_offset:

       Given: xmin = ymin = 0
              xmax = ymax = 10 
              xincr = yincr = 1

        For a node grid we have:
                (1) nx = (xmax - xmin) / xincr + 1 = 11
                    ny = (ymax - ymin) / yincr + 1 = 11
                (2) node # 0 is at (x,y) = (xmin, ymax) = (0,10) and 
                    represents the value for a box of size (1,1)
                    centered on the node.

        For a pixel grid we have:
                (1) nx = (xmax - xmin) / xincr = 10
                    ny = (ymax - ymin) / yincr = 10
                (2) node # 0 is at (x,y) = (xmin + 0.5*xincr, ymax - 
                    0.5*yincr) = (0.5, 9.5) and represents the value  
                    for a box with dimensions (1,1) centered on the node.
*/
