/* hydrobase.h */

/* define the hydrobase file format and properties available */


#ifndef    HYDROBASE

#define    HYDROBASE  1

/************ available properties ***************/

#define  MAXPROP  22
enum property { PR, DE, TE,TH, SA, OX, N2, N3, P4, SI, HT, S0, S1, S2, S3, S4, S_, BF, PV, SV, VA, SF};

 
#define    NBHEAD    76      /* # of bytes in header including LF */
#define    NBSEP      3      /* # of bytes separating stations incl LF */

#define   OVERWRITE  0       /* choose one of these modes for output files */
#define   NOCLOBBER  1
#define   APPEND     2   

struct HYDRO_HDR {
       char country[3], ship[3];      /* 2 char code + end-of-string char */
       int  cruise, station, year, month, day;
       float lat, lon;
       int  pdr, nobs, nprops, ms10, ms1;
       int *prop_id;               /* index to observ_prop identifiers */ 
};

struct HYDRO_DATA {
       int nobs, nprops;
       double *observ[MAXPROP];
};

#endif

