/*  invertblanks.c  

   Reads a file of lat/lon pairs, and identifies the gridpoints 
  which are not specified. For such points, "lon lat 0.0" are written to
  the stdout device.
*/

#include <stdio.h>
#include <math.h>
#include <string.h>



     /* boundaries for grid */

float   xmin, xmax, ymin, ymax, delta_x, delta_y;     
int     ncols, nrows;

void main(argc, argv)
int   argc;
char *argv[];
{
   FILE *infile, *outfile;
   short bopt,  iopt;
   char *st, *name[2];
   int   error, n, i, row, col;
   float lat, lon;
   int **x, x1; 
   void print_usage();
   int readprop();

/* check for command line arguments */

   if (argc < 2) {
     print_usage(argv[0]);
     exit(1);
   }

/* set these default values... */

   bopt  = iopt  = 0;
   error = 0;
   outfile = stdout;
   n = 0;


/*  parse the command line arguments */

   for (i = 1; i < argc; i++) {
      if (argv[i][0] == '-') {
            switch (argv[i][1]) {
               case 'B':                    /* get grid bounds */
                        bopt = 1;
                        st = &argv[i][2];
                           if (*st == '/')
                               ++st;
                        error = (sscanf(st,"%f", &xmin) != 1);
                        while (*(st++) != '/')
                           ;  
                        error += (sscanf(st,"%f", &xmax) != 1);
                        while (*(st++) != '/')
                           ;  
                        error += (sscanf(st,"%f", &ymin) != 1);
                        while (*(st++) != '/')
                           ;  
                        error += (sscanf(st,"%f", &ymax) != 1);
                        break;

               case 'I':
                        iopt = 1;
                        error = (sscanf(&argv[i][2],"%f", &delta_x) == 1) ? 0 : 1;
                        delta_y = delta_x;
                        st = strchr(&argv[i][2],'/');
                        if (st != NULL) {
                          sscanf(++st,"%f", &delta_y);
                        }
                        break;


               default:
                        error = 1;

          }    /* end switch */

          if (error ) {
             fprintf(stderr,"\nError parsing command line args.\n");
             fprintf(stderr,"     in particular: '%s'\n", argv[i]);
             exit(1);
          }

       }  /* end if */
       else {
          if (n < 1) 
             name[n++] = argv[i];
          
          else {
             fprintf(stderr,"\nToo many input files specified!\n");
             fprintf(stderr,"Ignoring %s\n", argv[i]);
          }
       }

   }  /* end for */

   if (!bopt || !iopt || (n < 1) ) {
       fprintf(stderr,"\nYou must specify input file, bounds, and gridspacing!\n");
       exit(1);
   }
   /* compute dimensions of matrix formed by grid  */

   nrows = (int) ((ymax - ymin) / delta_y);
   ncols = (int) ((xmax - xmin) / delta_x);
      

/*   allocate space for gridded values and initialize... */

   x = (int **) malloc(nrows * sizeof(int *));
   for (i = 0; i < nrows; ++i ) {
      x[i] = (int *) malloc(ncols * sizeof(int));
   }
   for (row = 0; row < nrows; ++row) {
      for (col = 0; col < ncols; ++col) {
          x[row][col] = 0;
      }
   }

/*   read in lat/lon  file ... */
 
   n = readprop(name[0], x);

/* now  output lon/lat pairs where there is no data ... */


   for (row = 0; row < nrows; ++row) {
       for (col = 0; col < ncols; ++col) {
        if (x[row][col] == 0) {
           lon = xmin +  col * delta_x;
           lat = ymin + row * delta_y;
           fprintf(outfile,"%8.3f %8.3f 0.0 \n", lon, lat);
        }
      }
   }
   
   close(infile);
   fflush(outfile);
   fprintf(stderr, "Done.\n");
   exit(0);
}  /* end main */

/****************************************************************************/

void print_usage(program)
char *program;
{
   fprintf(stderr,"\nUsage:  %s filename  -Bwest/east/south/north -Ideltax/deltay  > output_file", program);
   fprintf(stderr,"\n\n");  
   return;
}
/***********************************************************************/
int readprop(filename, x)
char *filename;
int **x;

{
   FILE *infile;
   float lon, lat;
   int row, col;


   if ((infile = fopen(filename, "r")) == NULL) {
        fprintf(stderr, "\n Unable to open %s for input\n\n", filename);
        exit(1);
   }
   fprintf(stderr," Opened %s ...\n", filename);

   while (fscanf(infile,"%f%f", &lon, &lat) != EOF) {
     row = (int) (.0001 + (lat - ymin) / delta_y);
     col = (int) (.0001 + (lon - xmin) / delta_x);


     /* check that it is within the bounds */

     if ((row >= 0) && (row < nrows) && (col >= 0) && (col < ncols)) 
            x[row][col] = 1;
   }

   close (infile);

   return (0);

}  /* end readprop() */




