      subroutine oamap (a,alu,nmtx,indx,nobs,xobs,yobs,tobs,fper,fcor,
     &                  nmap,xmap,ymap,tmap,method,fmap,emap,wac)
c
c=======================================================================
c                                                                    ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     A        observation correlation matrix (real array).          ===
c     ALU      LU decomposition of matrix A (real array).            ===
c     NMTX     number of elemets in correlation matrix (integer).    ===
c     INDX     vector which records the row permutations of ALU      ===
c              affected by the partial pivoting (integer array).     ===
c     NOBS     number of observations (integer).                     ===
c     XOBS     X position of observation (real array).               ===
c     YOBS     Y position of observation (real array).               ===
c     TOBS     time of observation (real array).                     ===
c     FPER     observation field anomaly (real array).               ===
c     FCOR     work vector which contains initially the correlation  ===
c              between observation and estimate positions and then   ===
c              the solution to OA equations (real array).            ===
c     NSEL     number of points to estimate (integer).               ===
c     XMAP     X positions to estimate (real array).                 ===
c     YMAP     Y positions to estimate (real array).                 ===
c     TMAP     time of estimation (real).                            ===
c     METHOD   solution method (integer):                            ===
c              METHOD=0  =>  direct, LU decomposition.               ===
c              METHOD=1  =>  minimization, conjugate gradient.       ===
c              METHOD=2  =>  1D inversion.                           ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     FMAP     optimal estimate (real array).                        ===
c     EMAP     normalized error variance (real array).               ===
c                                                                    ===
c  Calls:  ACOR, LUBKSB, LUDCMP                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ier,ij,ij1,j,method,n,nmtx,nmap,nobs,knobs,k
      integer indx(nobs)
      integer nblock,ibegin,iend,irange,l,idone
      real aval,aval1,c0,c1,errval,tmap,val
      real a(nmtx),alu(nmtx),emap(nmap),fcor(nobs),fmap(nmap),fper(nobs)
     &     ,q(mobs),tobs(nobs),pvec(mobs),wac(nmtx),wk1(mobs),wk2(mobs),
     &     wk3(mobs),wk4(mobs),xmap(nmap),xobs(nobs),ymap(nmap),
     &     yobs(nobs)
      real acor
c
      parameter (c0=0.0,c1=1.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      if(method.le.1) then
c
c  ----------------------
c  Use matrix algorithms.
c  ----------------------
c
        do 80 n=1,nmap
c
c  Compute correlation vector between observation and estimate
c  positions.
c
          do 10 i=1,nobs
            fcor(i)=acor(xmap(n),ymap(n),tmap,xobs(i),yobs(i),tobs(i))
  10      continue
c
c  Solve system of linear equations by back substitution.  The solution
c  vector is returned in FCOR.
c
          if (method.eq.0) then
            call lubksb (alu,nobs,nobs,indx,fcor)
          elseif(method.eq.1) then
            do 15 i=1,nobs
              ij=i+(i-1)*nobs
              pvec(i)=fcor(i)/a(ij)
 15         continue
            call descent (a,pvec,fcor,wk1,wk2,wk3,wk4,nobs,ier)
            if(ier.eq.1) then
              call exitus('OAMAP:descent')
            endif
          endif
c
c  Compute error variance.
c
          emap(n)=c1
          if (method.eq.0) then
            do 30 j=1,nobs
              do 20 i=1,nobs
                ij=i+(j-1)*nobs
                emap(n)=emap(n)-fcor(i)*a(ij)*fcor(j)
  20          continue
  30        continue
          elseif (method.eq.1) then
            do 50 j=1,nobs
              do 40 i=1,nobs
                ij=i+(j-1)*nobs
                emap(n)=emap(n)-pvec(i)*a(ij)*pvec(j)
  40          continue
  50        continue
          endif
c
c  Compute optimal estimate.
c
          fmap(n)=c0
          if (method.eq.0) then
            do 60 i=1,nobs
              fmap(n)=fmap(n)+fper(i)*fcor(i)
  60        continue
          elseif (method.eq.1) then
            do 70 i=1,nobs
              fmap(n)=fmap(n)+fper(i)*pvec(i)
  70        continue
          endif
 80     continue
c
      elseif(method.eq.2) then
c
c  -----------------
c  Use 1D algorithm.
c  -----------------
c
c
c -- set diagonal value of error correlation matrix
c
        call oa_err(errval)
c
c -- compute initial correlation matrix
c -- a(nobs,nobs) between obs.
c
        do 100 j=1,nobs
          do 90 k=j,nobs
            ij=j+(k-1)*nobs
            wac(ij) = acor(xobs(k),yobs(k),tobs(k),xobs(j),yobs(j),
     &                                                          tobs(j))
            ij1=k+(j-1)*nobs
            wac(ij1)=wac(ij)
 90       continue
 100    continue
c
c -- partition nmap in blocks of size nobs
c
        nblock=nobs
        ibegin=1
        iend=ibegin+nblock-1
        iend=min(nmap,iend)
        idone=0
c
c -- start computation by blocks
c
        do 300 while (idone.eq.0)
c
c -- set obs to obs correlations
c
          do 101 j=1,nobs
            do 91 k=j,nobs
              ij=j+(k-1)*nobs
              a(ij)=wac(ij)
              ij1=k+(j-1)*nobs
              a(ij1)=wac(ij)
 91         continue
 101      continue
c
c -- compute initial correlation matrix
c -- alu(nobs,nblock) between obs and target points.
c
          irange=iend-ibegin+1
          do 120 j=1,nobs
            do 110 i=1,irange
              ij=i+(j-1)*nobs
              l=ibegin+i-1
              alu(ij)=acor(xmap(l),ymap(l),tmap,xobs(j),yobs(j),tobs(j))
 110        continue
 120      continue
c
c -- initial  a-priori values: zero
c
          do 130 i=1,irange
            l=ibegin+i-1
            fmap(l)=c0
            emap(l)=c1
 130      continue
          do 140 k=1,nobs
            wk1(k)=c0
            wk3(k)=c1
 140      continue
c
c -- update correlation matrices a,alu and field estimates fmap
c -- one observation at a time [indek k]
c
c -- Tarantola algorithm (Inverse Problem Theory, 1994,p.296)
c --  has been adapted to extract the minimal
c --  information required in the OA.
c
          do 230 k=1,nobs
            val=fper(k)-wk1(k)
c
c -- collect  correlation between obs point and target points
c
            do 150 i=1,irange
               ij=i+(k-1)*nobs
              q(i)=alu(ij)
 150        continue
c
            aval=errval
            aval=aval+wk3(k)
            aval1=c1/aval
c
c -- collect  correlation between obs point and obs points
c
            do 160 j=1,nobs
              ij=j+(k-1)*nobs
              wk2(j)=a(ij)
 160        continue
c
c -- update apriori  value and correlation at target points
c
            do 170 i=1,irange
              l=ibegin+i-1               
              fmap(l)=fmap(l)+q(i)*val*aval1
 170        continue
c
c -- do not update correlations that will not be used later on
c        
            knobs=k+1
            knobs=min(nobs,knobs)
            do 200 i=1,irange
              do 190 j=knobs,nobs
                ij=i+(j-1)*nobs
                alu(ij)=alu(ij)-q(i)*wk2(j)*aval1
 190          continue
              l=ibegin+i-1               
              emap(l)=emap(l)-q(i)*q(i)*aval1
 200        continue
c
c -- update apriori  value and correlation at target points
c -- Note wk1 and a(nobs,nobs) updated  partially.
c -- the index ij in the collection loop for a MUST be consistent
c -- with the index in the following two loops.
c
            do 220 i=knobs,nobs
              wk1(i)=wk1(i)+wk2(i)*val*aval1
              wk3(i)=wk3(i)-wk2(i)*wk2(i)*aval1
              do 210 j=1,nobs
                ij=j+(i-1)*nobs
                a(ij)=a(ij)-wk2(i)*wk2(j)*aval1
 210          continue
 220        continue
 230      continue
c
          ibegin=iend+1
          iend=ibegin+nblock-1
          iend=min(nmap,iend)
          if(ibegin.gt.nmap)idone=1
c
 300    continue
c
      endif
c
      return
      end
