      program make_transbdy
c
c=======================================================================
c                                                                    ===
c  This program extracts boundary conditions for the initial         ===
c  estimate of the transport streamfunction from the results         ===
c  for a larger domain.                                              ===
c                                                                    ===
#ifndef sunfpe
c  Calls:  EXITUS,        GET_ISVAL,  MKTBY_DATA,  MKTBY_PARM,       ===
c          WRT_TRANSBDY,  XTR_PSIBY                                  ===
#else
c  Calls:  EXITUS,      GET_ISVAL,     MKTBY_DATA,  MKTBY_PARM,      ===
c          MY_HANDLER,  WRT_TRANSBDY,  XTR_PSIBY                     ===
#endif
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <fne_dom.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer nopn
#ifdef sunfpe
       integer ieeer,my_handler,ieee_handler
#endif
      integer corrcst(mcseg),lenopn(mcseg)
      real         pbar(np),popn(mpseg,mcseg),psisl(mcseg)
      character*80 gcrsfil,gfnefil,pifile,trnsfile
c
#ifdef sunfpe
       external my_handler
c
#endif
c=======================================================================
c  Begin executable code.
c=======================================================================
#ifdef sunfpe
c
c-----------------------------------------------------------------------
c  Set trap for floating point exceptions.
c-----------------------------------------------------------------------
c
      ieeer=ieee_handler('set','common',my_handler)
      if(ieeer.ne.0) print *,' IEEE_HANDLER cannot set my_handler'
#endif
c
c-----------------------------------------------------------------------
c  Get run parameters.
c-----------------------------------------------------------------------
c
      call mktby_parm (gcrsfil,gfnefil,pifile,trnsfile)
c
c-----------------------------------------------------------------------
c  Get data.
c-----------------------------------------------------------------------
c
      call mktby_data (gcrsfil,gfnefil,pifile,pbar)
c
c-----------------------------------------------------------------------
c  Extract boundary conditions.
c-----------------------------------------------------------------------
c
      call xtr_psiby (pbar,nopn,lenopn,popn)
c
c-----------------------------------------------------------------------
c  Extract island values.
c-----------------------------------------------------------------------
c
      call get_isval (pbar,corrcst,psisl)
c
c-----------------------------------------------------------------------
c  Write results.
c-----------------------------------------------------------------------
c
      call wrt_transbdy (trnsfile,nopn,fnisl,lenopn,mpseg,popn,corrcst,
     &                   psisl)
c
c-----------------------------------------------------------------------
c  End program.
c-----------------------------------------------------------------------
c
      call exitus ('MAKE_TRANSBDY DONE')
c
      end
