      subroutine vertgrid
c
c=======================================================================
c                                                                    ===
c  This subroutine sets the depths of each tracer and velocity grid  ===
c  point in the hybrid (single or double transformation) coordinate  ===
c  system:                                                           ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /HYBRID/                                                          ===
c                                                                    ===
c     DBLSIGMA  Flag for double sigma transfomation. (integer)       ===
c               [0] no,  [1] yes                                     ===
c     HV        The bottom depth at V-grid points.   (real array; cm)===
c     HAVG      Average thickness of hybrid levels.  (real; cm)      ===
c     HC        Depth of the interface.              (real; cm)      ===
c     HZ        Flat level thicknesses               (real array; cm)===
c     KC        Coordinate interface level           (integer)       ===
c     ZC1       Coordinate interface minimum depth.  (real; cm)      ===
c     ZC2       Coordinate interface maximum depth.  (real; cm)      ===
c     ZREF      Coordinate interface ref. depth.     (real; cm)      ===
c     ZSLOPE    Coordinate interface slope param.    (real)          ===
c                                                                    ===
c  /NDIMEN/                                                          ===
c                                                                    ===
c     IM   Number of points in the x-direction.      (integer)       ===
c     JM   Number of points in the y-direction.      (integer)       ===
c     KM   Number of points in the z-direction.      (integer)       ===
c                                                                    ===
c  /ZDAT/                                                            ===
c                                                                    ===
c     H        The bottom depth at T-grid points.   (real array; cm) ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /HYBRID/                                                          ===
c                                                                    ===
c     DEPTHMT   Depths at the middle of T-boxes.    (real array; cm) ===
c     DEPTHMV   Depths at the middle of V-boxes.    (real array; cm) ===
c     DZT       Thicknesses over T-grid.            (real array; cm) ===
c     DZV       Thicknesses over V-grid.            (real array; cm) ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <hybrid.h>
#include <ndimen.h>
#include <zdat.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,imjm,ip,j,k,km1
#ifdef reset_h
     &        ,ip0,ip1
#endif
      logical first
      real    c0,c2,fac,favg,fdif,fv,hvmfv,p25,p5,sigma,sigmam1,zvt
#ifndef reset_h
     &     ,ft,htmft
#endif
      real depthbv(nz)
#ifndef reset_h
     &     ,depthbt(nz)
#else
     &     ,dum(mx,nz),dzqz(mx,nz,0:1),dzzqz(mx,nz,0:1)
#endif
c
      parameter (c2=2.0,p25=0.25)
      parameter (c0=0.0,p5=0.5)
c
      save fac,favg,fdif,first
      data first /.true./
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      if(dblsigma.eq.1) then
c
c=======================================================================
c  Double "sigma" vertical transformation.
c=======================================================================
c
c  Set often used interface parameters
c
        if(first) then
          favg=p5*(zc1+zc2)
          fdif=p5*(zc1-zc2)
          if(fdif.ne.c0) then
            fac=zslope/fdif
          else
            fac=c0
          endif
          first=.false.
        endif
c
c-----------------------------------------------------------------------
c  Compute depths at the bottom of the tracer and velocity boxes.
c-----------------------------------------------------------------------
c
        do 50 j=1,jm
          do 40 i=1,im
            ip=i+(j-1)*im
# ifndef reset_h
            ft=favg+fdif*tanh(fac*(h (ip)-zref))
            htmft=h (ip)-ft
# endif
            fv=favg+fdif*tanh(fac*(hv(ip)-zref))
            hvmfv=hv(ip)-fv
c
c-----------------------------------------------------------------------
c  In upper sigma system.
c-----------------------------------------------------------------------
c
            sigma=c0
            do 10 k=1,kc
              sigma=sigma+hz(k)/hc
# ifndef reset_h
              depthbt(k)=sigma*ft
# endif
              depthbv(k)=sigma*fv
  10        continue
c
c-----------------------------------------------------------------------
c  In lower sigma system.
c-----------------------------------------------------------------------
c
            sigmam1=c0
            do 20 k=kc+1,km
              sigmam1=sigmam1+hz(k)/havg
# ifndef reset_h
              depthbt(k)=ft+sigmam1*htmft
# endif
              depthbv(k)=fv+sigmam1*hvmfv
  20        continue
c
c-----------------------------------------------------------------------
c  Compute depths at the middle of the tracer and velocity boxes.
c-----------------------------------------------------------------------
c
            do 30 k=1,km
              if(k.eq.1) then
# ifndef reset_h
                depthmt(ip,k)=0.5*depthbt(k)
# endif
                depthmv(ip,k)=0.5*depthbv(k)
              else
# ifndef reset_h
                depthmt(ip,k)=0.5*(depthbt(k)+depthbt(k-1))
# endif
                depthmv(ip,k)=0.5*(depthbv(k)+depthbv(k-1))
              endif
  30        continue
  40      continue
  50    continue
      else
c
c=======================================================================
c  Single "sigma" vertical transformation.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Determine depths (bottom of the boxes) in flat levels.
c-----------------------------------------------------------------------
c
        do 100 j=1,jm
          do 90 i=1,im
            ip=i+(j-1)*im
            sigma=c0
            do 60 k=1,kc
              sigma=sigma+hz(k)
              zvt=sigma
# ifndef reset_h
              depthbt(k)=zvt
# endif
              depthbv(k)=zvt
  60        continue
c
c-----------------------------------------------------------------------
c  Determine depths (bottom of the boxes) in "sigma" levels.
c-----------------------------------------------------------------------
c
            sigma=c0
            do 70 k=kc+1,km
              sigma=sigma+hz(k)/havg
# ifndef reset_h
              depthbt(k)=hc+sigma*(h (ip)-hc)
# endif
              depthbv(k)=hc+sigma*(hv(ip)-hc)
  70        continue
c
c-----------------------------------------------------------------------
c  Compute depths at the middle of the tracer and velocity boxes.
c-----------------------------------------------------------------------
c
            do 80 k=1,km
              if(k.eq.1) then
# ifndef reset_h
                depthmt(ip,k)=0.5*depthbt(k)
# endif
                depthmv(ip,k)=0.5*depthbv(k)
              else
# ifndef reset_h
                depthmt(ip,k)=0.5*(depthbt(k)+depthbt(k-1))
# endif
                depthmv(ip,k)=0.5*(depthbv(k)+depthbv(k-1))
              endif
  80        continue
  90      continue
 100    continue
      endif
c
#if defined reset_h
c-----------------------------------------------------------------------
c  Determine depths at tracer points.
c  Depths  at center of tracer boxes depthmt and bottom depth hd
c-----------------------------------------------------------------------
c
      do 150 j=2,jm
         ip =im*(j-1)
         ip0=im*(j-2)
         do 1000 i=1,im
            dzzqz(i,1,0)=depthmv(ip0+i,1)
            dzqz(i,1,0)=c2*dzzqz(i,1,0)
            dzzqz(i,1,1)=depthmv(ip+i,1)
            dzqz(i,1,1)=c2*dzzqz(i,1,1)
 1000    continue
c
c-----------------------------------------------------------------------
c  Compute spacing in remaining levels.
c-----------------------------------------------------------------------
c
#  ifndef barotropic
        do 1100 k=2,km
           km1=k-1
           do 1200 i=1,im
              dzzqz(i,k,0)=depthmv(ip0+i,k)-depthmv(ip0+i,km1)
              dzqz(i,k,0)=c2*dzzqz(i,k,0)-dzqz(i,km1,0)
              dzzqz(i,k,1)=depthmv(ip+i,k)-depthmv(ip+i,km1)
              dzqz(i,k,1)=c2*dzzqz(i,k,1)-dzqz(i,km1,1)
 1200      continue
 1100   continue
#  endif
         do 110  i=2,im
            ip=i+im*(j-1)
            do 120  k=1,km
               depthmt(ip,k)=p25*(dzqz(i-1,k,0)+dzqz(  i,k,0)+
     *                            dzqz(i-1,k,1)+dzqz(  i,k,1))
 120         continue
            dum(i,1)=p5*depthmt(ip,1)
#  ifndef barotropic
            do 130 k=2,km
               dum(i,k)=p5*(depthmt(ip,k-1)+depthmt(ip,k))+dum(i,k-1)
 130         continue
#  endif
            h(ip)=dum(i,km)+p5*depthmt(ip,km)
            do 140 k=1,km
               depthmt(ip,k)=dum(i,k)
 140         continue
 110      continue
 150   continue
c
c-----------------------------------------------------------------------
c  Determine depths  at tracer  edges. j=1,i=1
c  Depths  at center of tracer boxes htz and bottom depth hd
c-----------------------------------------------------------------------
c
#  ifdef cyclic
      do 160 i=2,im
         ip1=i+im
         ip=i
         h(ip)=h(ip1)
         do 160 k=1,km
            depthmt(ip,k)=depthmt(ip1,k)
 160  continue
      do 170 j=1,jm
         ip1=im-2+im*(j-1)
         ip=1+im*(j-1)
         h(ip)=h(ip1)
         h(ip1+2)=h(ip+1)
         do 170 k=1,km
            depthmt(ip,k)=depthmt(ip1,k)
            depthmt(ip1+2,k)=depthmt(ip+1,k)
 170  continue
#   else
      do 160 j=2,jm
         ip=1+im*(j-1)
         h(ip)=h(ip+1)
         do 160 k=1,km
            depthmt(ip,k)=depthmt(ip+1,k)
 160  continue
      do 170 i=2,im
         ip=i
         ip1=i+im
         h(ip)=h(ip1)
         do 170 k=1,km
            depthmt(ip,k)=depthmt(ip1,k)
 170  continue
      h(1)=p5*(h(2)+h(1+im))
      do 180 k=1,km
         depthmt(1,k)=p5*(depthmt(2,k)+depthmt(1+im,k))
 180  continue
#  endif
c
#endif
c-----------------------------------------------------------------------
c  Create thickness arrays
c-----------------------------------------------------------------------
c
      imjm = im*jm
c
      do 190 ip = 1, imjm
         dzt(ip,1) = c2*depthmt(ip,1)
         dzv(ip,1) = c2*depthmv(ip,1)
 190  continue
c
      do 200 k  = 2, km
      do 200 ip = 1, imjm
         km1       = k - 1
         dzt(ip,k) = c2*(depthmt(ip,k)-depthmt(ip,km1)) - dzt(ip,km1)
         dzv(ip,k) = c2*(depthmv(ip,k)-depthmv(ip,km1)) - dzv(ip,km1)
 200  continue
c
      return
      end
