function [xnew,ynew] = medsubsam (x,y,nbin);
%
% function [xnew,ynew] = medsubsam (x,y,nbin);
%
% This function sub-samples a curve by doing a median filter
% with a given bin width and retaining only the median values in the
% bins.
%
% ------
% Input:
% ------
%
%    X      Original curve x-coordinates.
%    Y      Original curve y-coordinates.
%    NBIN   Sub-sampling bin size.
%
% -------
% Output:
% -------
%
%    XNEW   Sub-sampled curve x-coordinates.
%    YNEW   Sub-sampled curve y-coordinates.

%-------------------------------------------------------------------------------
% Determine sizes and sampling indices.
%-------------------------------------------------------------------------------

npt = length(x);

nptnew = fix(npt/nbin);

nst  = 1 + fix(rem(npt,nbin)/2);
nnd  = nst + nptnew*nbin - 1;

wkind = nst:nnd;

%-------------------------------------------------------------------------------
% Sub-sample curve.
%-------------------------------------------------------------------------------

xnew = median(reshape(x(wkind),nbin,nptnew));
ynew = median(reshape(y(wkind),nbin,nptnew));
