% pe_line_chk
%
% This script plots the extracted line reported KE data.

%-------------------------------------------------------------------------------
% Set default run parameters.
%-------------------------------------------------------------------------------

defname = 'pe_ke.dat';
defdt   = 450.0;
defttl  = 'Run 1';

%-------------------------------------------------------------------------------
% Get run parameters.
%-------------------------------------------------------------------------------

%----------------------------
%--- Get input file name. ---
%----------------------------

name = input (['Enter name of input file [',defname,']: '],'s');

if isempty(name),
   name = defname;
end;

%----------------------
%--- Get time step. ---
%----------------------

dt = input (['Enter model time step (seconds) [',num2str(defdt),']: ']);

if isempty(dt),
   dt = defdt;
end;

%-----------------------
%--- Get base title. ---
%-----------------------

ttl = input (['Enter title for plots [',num2str(defttl),']: '],'s');

if isempty(ttl),
   ttl = defttl;
end;

%-------------------------
%--- Get filter width. ---
%-------------------------

nbin = input ('Enter bin for median filter [no filter]: ');

if isempty(ttl),
   ttl = defttl;
end;

clear defdt defname defttl;

%-------------------------------------------------------------------------------
% Get cleaned, line printed KE data.
%-------------------------------------------------------------------------------

%------------------
%--- Read data. ---
%------------------

fid = fopen (name,'r');

[A count] = fscanf (fid,'%d %f %f %f',[4 inf]);

status = fclose (fid);

clear count fid name status;

%---------------------
%--- Extract data. ---
%---------------------

t     = (A(1,:)-1).*(dt/(3600*24));
ke    = A(2,:);
dtemp = A(3,:);
dsalt = A(4,:);

clear A dt;

%-------------------------------------------------------------------------------
% If requested, filter results.
%-------------------------------------------------------------------------------

if ~isempty(nbin),

   %----------------------------------------------
   %--- Make sure bin is an odd integer, >= 3. ---
   %----------------------------------------------

   if ~rem(nbin,2),
      nbin = nbin + 1;
   end;

   if (nbin<3),
      nbin = 3;
   end;

   %------------------------------
   %--- Filter kinetic energy. ---
   %------------------------------

   data = [t' ke'];
   [p,itcnt] = med_filt (data,nbin);
   disp (['  --- Filter kinetic energy,  itcnt=',num2str(itcnt)]);
   ke = p(:,2);

   %------------------------------------------
   %--- Filter temperature rate of change. ---
   %------------------------------------------

   data = [t' dtemp'];
   [p,itcnt] = med_filt (data,nbin);
   disp (['  --- Filter temperature rate of change,  itcnt=',num2str(itcnt)]);
   dtemp = p(:,2);

   %---------------------------------------
   %--- Filter salinity rate of change. ---
   %---------------------------------------

   data = [t' dsalt'];
   [p,itcnt] = med_filt (data,nbin);
   disp (['  --- Filter salinity rate of change,  itcnt=',num2str(itcnt)]);
   dsalt = p(:,2);

   clear data itcnt p;

   %--------------------
   %--- Reset title. ---
   %--------------------

   ttl = [ttl,'  (med:  ',num2str(nbin),'pt)'];

end;

clear nbin;

%-------------------------------------------------------------------------------
% Plot results.
%-------------------------------------------------------------------------------

%---------------
%--- Plot KE ---
%---------------

subplot (2,2,1);

plot (t,ke); ...
set(gca,'FontName','Times'); ...
xlabel ('Time  (days)'); ...
ylabel ('Kinetic Energy'); ...
title (ttl); ...
grid on;

%-------------------------------
%--- Plot Temperature Change ---
%-------------------------------

subplot (2,2,3);

plot (t,dtemp); ...
set(gca,'FontName','Times'); ...
xlabel ('Time  (days)'); ...
ylabel ('Temperature Rate of Change'); ...
title (ttl); ...
grid on;

%----------------------------
%--- Plot Salinity Change ---
%----------------------------

subplot (2,2,4);

plot (t,dsalt); ...
set(gca,'FontName','Times'); ...
xlabel ('Time  (days)'); ...
ylabel ('Salinity Rate of Change'); ...
title (ttl); ...
grid on;

clear dsalt dtemp ke t ttl;
