      subroutine defout
c
c=======================================================================
c                                                                    ===
c  This routine creates the PE model output NetCDF file, it defines  ===
c  its dimensions,  the geometry (coordinates) variables  and their  ===
c  attributes, and the requested output variables their attributes.  ===
c  Depth positions are written in "meters" for  post-processing and  ===
c  and visualization purposes.                                       ===
c                                                                    ===
c  Calls:  NCAPT, NCAPTC, NCCRE, NCDDEF, NCENDF, NCPOPT, NCVDEF,     ===
c          NCVID, NCVPT, NCVGPC, NCVGP1   (NetCDF library)           ===
c          DEFNRG, DEPTHSLAB, EXITUS, LENGTH                         ===
c                                                                    ===
c  WARNING:   Character argument to NetCDF routines NCAPT, NCAPTC,   ===
c             NCDDEF, NCVDEF, and NCVID is (upper/lower) case        ===
c             sensitive.                                             ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <scalar.h>
#include <fullwd.h>
#include <onedim.h>
#include <moddat.h>
#include <filtdat.h>
#include <options.h>
#include <hybrid.h>
#include <runid.h>
#include <vertslabs.h>
#include <rhomean.h>
#include <cvmix.h>
#include <iounits.h>
#include <version.h>
#if defined bndy_rlx | defined cstfrc | defined botfrc
# include <bndyrlx.h>
#endif
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
# include <cbiopnh.h>
#endif
#include <netcdf.inc>
#include <pe_netcdf.h>
#if defined oias & defined fcsterr
# include <oiopts.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer imjmkm
      parameter (imjmkm=imt*jmt*km)
c
      integer ax2dim,ax3dim,ch24dim,ch80dim,dbgn,dend,i,iday,ip,iyday,
     *        iyear,j,k,klev,ldate,levdim,lmod,lvnum,m,madd,mbgn,mend,
     *        month,nskip,ntg3did,nvg3did,olevdim,sbgn,send,slen,tg2did,
     *        tg3did,tlatdim,tlondim,toutdim,tslevdim,usrdim1,usrdim2,
     *        vartyp,vbgn,vend,vecdim,vg2did,vg3did,vlatdim,vlondim,
     &        wtg3did,wvg3did
#if defined ext_tide & defined tide_zero
     *        ,tnsdim
#endif
#ifdef coast
      integer ntg2did,nvg2did
#endif
      integer count(4),start(4),tgrd2d(3),tgrd3d(4),tfld4d(4),vgrd2d(3),
     *        vgrd3d(4),vfld4d(5)
      FLOAT
     *      work(imjmkm)
      equivalence (work,rhobar)
      character*8  tchar
      character*11 dchar
      character*33 fmt
      character*44 fldnam
      character*256 wkstr
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Create NetCDF file.
c
      call ncpopt(ncverbos)
      ncoutid=nccre(outname,ncnoclob,rcode)
      if(rcode.eq.0) then
         ncoutst = 1
        else
         write(stdout,900) outname
         call exitus('DEFOUT')
      endif
c
c  Define the dimensions of the NetCDF fields.
c
      tlatdim=ncddef(ncoutid,'tlat',jmt,rcode)
      tlondim=ncddef(ncoutid,'tlon',imt,rcode)
      vlatdim=ncddef(ncoutid,'vlat',jmt,rcode)
      vlondim=ncddef(ncoutid,'vlon',imt,rcode)
      levdim=ncddef(ncoutid,'level',km,rcode)
      olevdim=ncddef(ncoutid,'outlev',nlev,rcode)
      vecdim=ncddef(ncoutid,'vector',2,rcode)
#if defined ext_tide & defined tide_zero
      tnsdim=ncddef(ncoutid,'tensor',4,rcode)
#endif
      toutdim=ncddef(ncoutid,'time',ncunlim,rcode)
      ax2dim=ncddef(ncoutid,'axis2',2,rcode)
      ax3dim=ncddef(ncoutid,'axis3',3,rcode)
      tslevdim=ncddef(ncoutid,'tslev',nprof,rcode)
      usrdim1=ncddef(ncoutid,'usrdim1',10,rcode)
      usrdim2=ncddef(ncoutid,'usrdim2',20,rcode)
      ch24dim=ncddef(ncoutid,'len24',24,rcode)
      ch80dim=ncddef(ncoutid,'len80',80,rcode)
c
c  Define dimension vectors for tracer and velocity type variables.
c
      tgrd2d(1)=ax2dim
      tgrd2d(2)=tlondim
      tgrd2d(3)=tlatdim
c
      tgrd3d(1)=ax3dim
      tgrd3d(2)=olevdim
      tgrd3d(3)=tlondim
      tgrd3d(4)=tlatdim
c
      tfld4d(1)=olevdim
      tfld4d(2)=tlondim
      tfld4d(3)=tlatdim
      tfld4d(4)=toutdim
c
      vgrd2d(1)=ax2dim
      vgrd2d(2)=vlondim
      vgrd2d(3)=vlatdim
c
      vgrd3d(1)=ax3dim
      vgrd3d(2)=olevdim
      vgrd3d(3)=vlondim
      vgrd3d(4)=vlatdim
c
      vfld4d(1)=vecdim
      vfld4d(2)=olevdim
      vfld4d(3)=vlondim
      vfld4d(4)=vlatdim
      vfld4d(5)=toutdim
c
c-----------------------------------------------------------------------
c  Define type of floating-point variables: single or double precision.
c-----------------------------------------------------------------------
c
#ifdef dblprec
      vartyp=ncdouble
#else
      vartyp=ncfloat
#endif
c
c-----------------------------------------------------------------------
c  Define titles and scalar variables and their attributes in the
c  NetCDF file.
c-----------------------------------------------------------------------
c
c  Create history attribute.
c
      call get_date (date_str)
      call length (date_str,ldate,dbgn,dend)
      call length (model,lmod,mbgn,mend)
      call length (vnum,lvnum,vbgn,vend)
      if (ldate.gt.0) then
        history=model(mbgn:mend)//', Version '//vnum(vbgn:vend)//', '
     &          //date_str(dbgn:dend)
      else
        history=model(mbgn:mend)//', Version '//vnum(vbgn:vend)
      endif
c
c  Create code identifier.
c
      call length (vdate,slen,sbgn,send)
      nskip=28-(slen+lmod+lvnum)
      write (fmt,960) nskip
      write (codeid,fmt) model(mbgn:mend),vnum(vbgn:vend),
     &                   vdate(sbgn:send)
c
c  Put global attributes to NetCDF file.
c
      wkstr = model(mbgn:mend)//' output fields'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'title',ncchar,slen,wkstr(sbgn:send)
     *             ,rcode)
      call length (outname,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'out_file',ncchar,slen,
     *             outname(sbgn:send),rcode)
      call length (nrgname,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'nrg_file',ncchar,slen,
     *             nrgname(sbgn:send),rcode)
#ifdef ldrifters
      call length (trkname,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'trk_file',ncchar,slen,
     *             trkname(sbgn:send),rcode)
      call length (dposnam,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'trk_parm',ncchar,slen,
     *             dposnam(sbgn:send),rcode)
#endif
#ifndef analytical
      call length (inpname,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'inp_file',ncchar,slen,
     *             inpname(sbgn:send),rcode)
#endif
#ifdef forcing
      call length (frcname,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'frc_file',ncchar,slen,
     *             frcname(sbgn:send),rcode)
#endif
#ifdef oias
      call length (assname,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'ass_file',ncchar,slen,
     *             assname(sbgn:send),rcode)
      call length (aparnam,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'ass_parm',ncchar,slen,
     *             aparnam(sbgn:send),rcode)
#endif
#ifdef extraction
      call length (xparnam,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'xtr_parm',ncchar,slen,
     *             xparnam(sbgn:send),rcode)
#endif
#if defined bioAnder | defined bioFasham | defined bioMcGillic | defined bioDuse
      call length (bparnam,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'bio_parm',ncchar,slen,
     *             bparnam(sbgn:send),rcode)
# ifdef bioDuse
      if(ipmod.eq.ipmbid) then
        call length (absonam,slen,sbgn,send)
        call ncaptc(ncoutid,ncglobal,'abs_parm',ncchar,slen,
     *       absonam(sbgn:send),rcode)
      endif
# endif
#endif
      call ncaptc (ncoutid,ncglobal,'type',ncchar,lmod,model(mbgn:mend),
     *             rcode)
      call ncaptc (ncoutid,ncglobal,'version',ncchar,lvnum,
     *             vnum(vbgn:vend),rcode)
      call length (history,slen,sbgn,send)
      call ncaptc (ncoutid,ncglobal,'history',ncchar,slen,
     *             history(sbgn:send),rcode)
c
c  Define character variables (titles).
c
      varid=ncvdef(ncoutid,'titlrun',ncchar,1,ch80dim,rcode)
      varid=ncvdef(ncoutid,'titlmdl',ncchar,1,ch80dim,rcode)
      varid=ncvdef(ncoutid,'titleic',ncchar,1,ch80dim,rcode)
      varid=ncvdef(ncoutid,'titlebc',ncchar,1,ch80dim,rcode)
      varid=ncvdef(ncoutid,'runic',ncchar,1,ch24dim,rcode)
c
c  Define PE model parameters.
c
      varid = ncvdef (ncoutid,'imt',nclong,0,0,rcode)
      wkstr = 'number of tracer points in the x-direction'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'jmt',nclong,0,0,rcode)
      wkstr = 'number of tracer points in the y-direction'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'km',nclong,0,0,rcode)
      wkstr = 'number of vertical levels'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'nt',nclong,0,0,rcode)
      wkstr = 'number of tracer type variables'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'lseg',nclong,0,0,rcode)
      wkstr = 'maximum number of sets of Start and End indices'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'misle',nclong,0,0,rcode)
      wkstr = 'maximum number of islands in the model basin'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'lbc',nclong,0,0,rcode)
      wkstr = 'number of arrays of slab incidental data'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'nfirst',nclong,0,0,rcode)
      wkstr = 'start/restart switch'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'restart'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_0',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'start from scratch'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_1',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'nlast',nclong,0,0,rcode)
      wkstr = 'number of timesteps to calculate'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'nnergy',nclong,0,0,rcode)
      wkstr = 'number of timesteps between energy diagnostics'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'ntsout',nclong,0,0,rcode)
      wkstr = 'number of timesteps between output of data'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,1,rcode)
c
      varid = ncvdef (ncoutid,'ntsi',nclong,0,0,rcode)
      wkstr = 'number of timesteps between print of information'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,1,rcode)
c
      varid = ncvdef (ncoutid,'nmix',nclong,0,0,rcode)
      wkstr = 'number of timesteps between mixing timesteps'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'mxscan',nclong,0,0,rcode)
      wkstr = 'maximum number of iterations for relaxation'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define horizontal and vertical viscosity parameters.
c
      varid = ncvdef (ncoutid,'mixvel',nclong,0,0,rcode)
      wkstr = 'momentum horizontal mixing scheme'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Shapiro filter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_1',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Laplacian at constant depths'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_2',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Laplacian along terrain following levels'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_3',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'mixtrc',nclong,0,0,rcode)
      wkstr = 'tracers horizontal mixing scheme'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Shapiro filter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_1',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Laplacian at constant depths'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_2',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Laplacian along terrain following levels'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_3',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'mixztd',nclong,0,0,rcode)
      wkstr = 'barotropic vorticity horizontal mixing scheme'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Shapiro filter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_1',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Laplacian'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_2',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'am',vartyp,0,0,rcode)
      wkstr = 'horizontal mixing of momentum'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter2 second-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'ah',vartyp,0,0,rcode)
      wkstr = 'horizontal mixing of heat, salinity and tracers'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter2 second-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'fkpm',vartyp,0,0,rcode)
      wkstr = 'vertical mixing of momentum'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter2 second-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'fkph',vartyp,0,0,rcode)
      wkstr = 'vertical mixing of heat, salinity and tracers'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter2 second-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
#ifdef shapiro
c
      varid = ncvdef (ncoutid,'nordv',nclong,0,0,rcode)
      wkstr = 'velocity: order of Shapiro filter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,2,rcode)
c
      varid = ncvdef (ncoutid,'ntimv',nclong,0,0,rcode)
      wkstr = 'velocity: number of Shapiro filter applications'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,47,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,1,rcode)
c
      varid = ncvdef (ncoutid,'nfrqv',nclong,0,0,rcode)
      wkstr = 'velocity: timesteps between Shapiro filtering'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,0,rcode)
c
      varid = ncvdef (ncoutid,'nordt',nclong,0,0,rcode)
      wkstr = 'tracers: order of Shapiro filter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,2,rcode)
c
      varid = ncvdef (ncoutid,'ntimt',nclong,0,0,rcode)
      wkstr = 'tracers: number of Shapiro filter applications'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,1,rcode)
c
      varid = ncvdef (ncoutid,'nfrqt',nclong,0,0,rcode)
      wkstr = 'tracers: timesteps between Shapiro filtering'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,0,rcode)
c
      varid = ncvdef (ncoutid,'nordp',nclong,0,0,rcode)
      wkstr = 'transport: order of Shapiro filter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,2,rcode)
c
      varid = ncvdef (ncoutid,'ntimp',nclong,0,0,rcode)
      wkstr = 'transport: number of Shapiro filter applications'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,1,rcode)
c
      varid = ncvdef (ncoutid,'nfrqp',nclong,0,0,rcode)
      wkstr = 'transport: timesteps between Shapiro filtering'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,0,rcode)
c
      varid = ncvdef (ncoutid,'nordz',nclong,0,0,rcode)
      wkstr = 'vorticity: order of Shapiro filter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,2,rcode)
c
      varid = ncvdef (ncoutid,'ntimz',nclong,0,0,rcode)
      wkstr = 'vorticity: number of Shapiro filter applications'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,1,rcode)
c
      varid = ncvdef (ncoutid,'nfrqz',nclong,0,0,rcode)
      wkstr = 'vorticity: timesteps between Shapiro filtering'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',nclong,1,0,rcode)
#endif
c
c  Define time steping parameters.
c
      varid = ncvdef (ncoutid,'dtts',vartyp,0,0,rcode)
      wkstr = 'length of timestep on tracers'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'seconds'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'dtuv',vartyp,0,0,rcode)
      wkstr = 'length of timestep on momentum'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'seconds'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid=ncvdef(ncoutid,'dtsf',vartyp,0,0,rcode)
      wkstr = 'length of timestep on transport streamfunction'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'seconds'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define relaxation and Coriolis treatment parameters.
c
      varid = ncvdef (ncoutid,'sor',vartyp,0,0,rcode)
      wkstr = 'coefficient for over-relaxation'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',vartyp,1,c1,rcode)
      call ncapt  (ncoutid,varid,'valid_max',vartyp,1,c2,rcode)
c
      varid = ncvdef (ncoutid,'crit',vartyp,0,0,rcode)
      wkstr = 'RMS relaxation convergence criterion'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'percentage'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'acor',vartyp,0,0,rcode)
      wkstr = 'coefficient for implicit treatment of Coriolis term'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt  (ncoutid,varid,'valid_min',vartyp,1,c0,rcode)
      call ncapt  (ncoutid,varid,'valid_max',vartyp,1,c1,rcode)
c
c  Define model domain parameters.
c
      varid = ncvdef (ncoutid,'coord',nclong,0,0,rcode)
      wkstr = 'flag for type of horizontal grid'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'cartesian (tangent plane) grid'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_0',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'unrotated spherical grid'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_1',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'rotated spherical grid'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'option_2',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'rlngd',vartyp,0,0,rcode)
      wkstr = 'transformation centroid longitude'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_east'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'rlatd',vartyp,0,0,rcode)
      wkstr = 'transformation centroid latitude'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_north'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'delx',vartyp,0,0,rcode)
      wkstr = 'domain longitudinal offset'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      if (coord.eq.0) then
        wkstr = 'centimeter'
       else
        wkstr = 'degrees'
      endif
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'dely',vartyp,0,0,rcode)
      wkstr = 'domain latitudinal offset'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      if (coord.eq.0) then
        wkstr = 'centimeter'
       else
        wkstr = 'degrees'
      endif
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'thetad',vartyp,0,0,rcode)
      wkstr = 'domain rotation angle'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define parameters for equation of state for seawater.
c
      varid = ncvdef (ncoutid,'rho0',vartyp,0,0,rcode)
      wkstr = 'mean density of seawater'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'kilogram meter-3'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'smean',vartyp,0,0,rcode)
      wkstr = 'mean salinity subtracted during computations'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'PSU'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
#ifdef leqstate
c
      varid = ncvdef (ncoutid,'rbar',vartyp,0,0,rcode)
      wkstr = 'mean density in linear equation of state'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'kilogram meter-3'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'sbar',vartyp,0,0,rcode)
      wkstr = 'mean salinity in linear equation of state'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'PSU'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'tbar',vartyp,0,0,rcode)
      wkstr = 'mean temperature in linear equation of state'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Celsius'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'scoef',vartyp,0,0,rcode)
      wkstr = 'saline contraction coefficient'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'PSU-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'tcoef',vartyp,0,0,rcode)
      wkstr = 'thermal expansion coefficient'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Celsius-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
#endif
#ifdef dblsigma
c
c  Define double vertical coordinate transformation parameters.
c
      varid = ncvdef (ncoutid,'zc1',vartyp,0,0,rcode)
      wkstr = 'shallowest depth of the coordinate interface'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'zc2',vartyp,0,0,rcode)
      wkstr = 'deepest depth of the coordinate interface'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'zref',vartyp,0,0,rcode)
      wkstr = 'reference depth for coordinate interface'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'zslope',vartyp,0,0,rcode)
      wkstr = 'slope parameter of the coordinate interface'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
#endif
#ifdef bndy_rlx
c
c  Define boundary relaxation parameters.
c
      varid = ncvdef (ncoutid,'dvbrlx',vartyp,0,0,rcode)
      wkstr = 'V-grid boundary relaxation spatial scale'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'grid points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt (ncoutid,varid,'shut_off',vartyp,1,c0,rcode)
c
      varid = ncvdef (ncoutid,'tvbrlx',vartyp,0,0,rcode)
      wkstr = 'V-grid boundary relaxation temporal scale'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'seconds'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt (ncoutid,varid,'shut_off',vartyp,1,c0,rcode)
c
      varid = ncvdef (ncoutid,'dtbrlx',vartyp,0,0,rcode)
      wkstr = 'T-grid boundary relaxation spatial scale'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'grid points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt (ncoutid,varid,'shut_off',vartyp,1,c0,rcode)
c
      varid = ncvdef (ncoutid,'ttbrlx',vartyp,0,0,rcode)
      wkstr = 'T-grid boundary relaxation temporal scale'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'seconds'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt (ncoutid,varid,'shut_off',vartyp,1,c0,rcode)
#endif
#ifdef cstfrc
c
c  Define coastal friction parameters.
c
      varid = ncvdef (ncoutid,'dcsfrc',vartyp,0,0,rcode)
      wkstr = 'Coastal friction spatial scale'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'grid points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt (ncoutid,varid,'shut_off',vartyp,1,c0,rcode)
c
      varid = ncvdef (ncoutid,'tcsfrc',vartyp,0,0,rcode)
      wkstr = 'Coastal friction temporal scale'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'seconds'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt (ncoutid,varid,'shut_off',vartyp,1,c0,rcode)
#endif
#ifdef botfrc
c
c  Define bottom friction parameters.
c
      varid = ncvdef (ncoutid,'dbtfrc',vartyp,0,0,rcode)
      wkstr = 'Bottom friction spatial scale'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'model levels'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt (ncoutid,varid,'shut_off',vartyp,1,c0,rcode)
c
      varid = ncvdef (ncoutid,'tbtfrc',vartyp,0,0,rcode)
      wkstr = 'Bottom friction temporal scale'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'seconds'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      call ncapt (ncoutid,varid,'shut_off',vartyp,1,c0,rcode)
#endif
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c
c  Define biological model parameters
c
      call defbparm (ncoutid,vartyp)
#endif
c
c-----------------------------------------------------------------------
c  Define flags, options, and switches arrays and their attributes
c  in the NetCDF file.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncoutid,'iflag',nclong,1,usrdim1,rcode)
      wkstr = 'initialization flags'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'iopt',nclong,1,usrdim1,rcode)
      wkstr = 'tunable options and switches'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'iout',nclong,1,usrdim2,rcode)
      wkstr = 'switches specifing which PE fields to write out'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
#if defined bioAnder | defined bioFasham | defined bioMcGillic | defined bioDuse
      varid = ncvdef (ncoutid,'ibiout',nclong,1,usrdim2,rcode)
      wkstr = 'switches specifing which biological fields to write out'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
#endif
      varid = ncvdef (ncoutid,'outlev',nclong,1,olevdim,rcode)
      wkstr = 'output vertical levels or depths'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meters, if value is greater than number of levels'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define mean TS profile.
c
      varid = ncvdef (ncoutid,'zclima',vartyp,1,tslevdim,rcode)
      wkstr = 'depths of mean TS profile'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'tclima',vartyp,1,tslevdim,rcode)
      wkstr = 'mean temperature profile'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Celsius'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'mean temperature, scalar'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'field',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'zclima'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'positions',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'sclima',vartyp,1,tslevdim,rcode)
      wkstr = 'mean salinity profile'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'PSU'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'mean salinity, scalar'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'field',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'zclima'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'positions',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define geometry variables and their attributes in the NetCDF file.
c-----------------------------------------------------------------------
c
c  Define depths and thicknesses for the flat reference levels.
c
      varid = ncvdef (ncoutid,'refz',vartyp,1,levdim,rcode)
      wkstr = 'depths at center of the flat grid vertical boxes'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'hz',vartyp,1,levdim,rcode)
      wkstr = 'thicknesses of the flat grid vertical boxes'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define horizontal grid spacings between tracer points.
c
      varid = ncvdef (ncoutid,'dxt',vartyp,1,tlondim,rcode)
      wkstr = 'zonal spacing between tracer points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncoutid,'dyt',vartyp,1,tlatdim,rcode)
      wkstr = 'meridional spacing between tracer points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define bathymetry at the tracer points.
c
      tbthid = ncvdef (ncoutid,'tbath',vartyp,2,tfld4d(2),rcode)
      wkstr = 'bathymetry at tracer points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tbthid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tbthid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'bathymetry, scalar'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tbthid,'field',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'tgrid2'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tbthid,'positions',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
#ifdef coast
c
c  Define land/sea mask at the tracer and velocity points.
c
      landtid = ncvdef (ncoutid,'landt',nclong,2,tfld4d(2),rcode)
      wkstr = 'land/sea mask at tracer points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landtid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'land'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landtid,'option_0',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'sea'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landtid,'option_1',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Tmask, scalar'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landtid,'field',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'tgrid2'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landtid,'positions',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      landvid = ncvdef (ncoutid,'landv',nclong,2,vfld4d(3),rcode)
      wkstr = 'land/sea mask at velocity points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landvid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'land'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landvid,'option_0',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'boundary'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landvid,'option_1',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'sea'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landvid,'option_2',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'Vmask, scalar'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landvid,'field',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'vgrid2'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,landvid,'positions',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
#endif
c
c  Define 2D grid positions at tracer and velocity points.  These fields
c  are used in the post-processing/visualization modules.
c
      tg2did = ncvdef (ncoutid,'tgrid2',vartyp,3,tgrd2d,rcode)
      wkstr = '2D grid positions at tracer points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg2did,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = '1: longitude, 2: latitude'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg2did,'axis',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_east, degrees_north'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg2did,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      vg2did = ncvdef (ncoutid,'vgrid2',vartyp,3,vgrd2d,rcode)
      wkstr = '2D grid positions at velocity points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg2did,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = '1: longitude, 2: latitude'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg2did,'axis',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_east, degrees_north'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg2did,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define 3D grid positions at tracer and velocity points.  These fields
c  are used in the post-processing/visualization modules.
c
      tg3did = ncvdef (ncoutid,'tgrid3',vartyp,4,tgrd3d,rcode)
      wkstr = '3D grid positions at tracer points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg3did,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = '1: longitude, 2: latitude, 3: depth'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg3did,'axis',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_east, degrees_north, meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,tg3did,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      vg3did = ncvdef (ncoutid,'vgrid3',vartyp,4,vgrd3d,rcode)
      wkstr = '3D grid positions at velocity points'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg3did,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = '1: longitude, 2: latitude, 3: depth'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg3did,'axis',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'degrees_east, degrees_north, meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,vg3did,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define 3D grid positions at the W-tracer points. These field
c  is used in the post-processing/visualization modules.
c
#ifdef bioFasham
      if((iout(7).eq.1).or.(iout(9).eq.1).or.(ibiout(nt-2+8).eq.1)) then
#else
      if((iout(7).eq.1).or.(iout(9).eq.1)) then
#endif
        wtg3did = ncvdef (ncoutid,'wtgrid3',vartyp,4,tgrd3d,rcode)
        wkstr = '3D grid positions at W-tracer points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wtg3did,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = '1: longitude, 2: latitude, 3: depth'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wtg3did,'axis',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'degrees_east, degrees_north, meter'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wtg3did,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
      endif
c
c  Define 3D grid positions at the W-velocity points. These field
c  is used in the post-processing/visualization modules.
c
      if((iout(6).eq.1).or.(iout(8).eq.1)) then
        wvg3did = ncvdef (ncoutid,'wvgrid3',vartyp,4,vgrd3d,rcode)
        wkstr = '3D grid positions at W-velocity points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvg3did,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = '1: longitude, 2: latitude, 3: depth'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvg3did,'axis',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'degrees_east, degrees_north, meter'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvg3did,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
      endif
c
c  Define 3D tracer and velocity box thicknesses.  These fields
c  are used to define the vertical system.
c
      tgrd3d(2) = levdim
      varid = ncvdef (ncoutid,'dzt',ncfloat,3,tgrd3d(2),rcode)
      tgrd3d(2) = olevdim
      wkstr = '3D tracer box thicknesses'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
      vgrd3d(2) = levdim
      varid = ncvdef (ncoutid,'dzv',ncfloat,3,vgrd3d(2),rcode)
      vgrd3d(2) = olevdim
      wkstr = '3D velocity box thicknesses'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,varid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define output variables and their attributes in the NetCDF file.
c-----------------------------------------------------------------------
c
c  Define time coordinate.
c
      toutid = ncvdef (ncoutid,'time',vartyp,1,toutdim,rcode)
      wkstr = 'time since initialization'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,toutid,'long_name',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
#if (defined forcing | defined peprf | defined ext_tide ) & defined resetjulian
      call caldate (d0start,dchar,tchar,iday,month,iyear,iyday)
#else
      call caldate (dstart,dchar,tchar,iday,month,iyear,iyday)
#endif
      write (wkstr,5) iyear,month,iday
   5  format (i4.4,'-',i2.2,'-',i2.2)
      call length (wkstr,slen,sbgn,send)
      wkstr = 'seconds since '//wkstr(sbgn:send)//' '//tchar//' 0:00'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,toutid,'units',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
      wkstr = 'time, scalar, series'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncoutid,toutid,'field',ncchar,slen,
     *             wkstr(sbgn:send),rcode)
c
c  Define transport streamfunction.
c
      if(iout(1).eq.1) then
        pbarid = ncvdef (ncoutid,'pbar',vartyp,3,tfld4d(2),rcode)
        wkstr = 'transport streamfunction'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pbarid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter3 second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pbarid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'transport, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pbarid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pbarid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,pbarid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,pbarid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define total (internal plus external) velocity components.
c
      if(iout(2).eq.1) then
        vtotid = ncvdef (ncoutid,'vtot',vartyp,5,vfld4d,rcode)
        wkstr = 'total velocity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vtotid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vtotid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'total velocity, vector, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vtotid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vtotid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,vtotid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,vtotid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define internal velocity components.
c
      if(iout(3).eq.1) then
        vcliid = ncvdef (ncoutid,'vclin',vartyp,5,vfld4d,rcode)
        wkstr = 'baroclinic velocity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vcliid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vcliid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'baroclinic velocity, vector, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vcliid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vcliid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,vcliid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,vcliid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define external velocity components.
c
      if(iout(4).eq.1) then
        vfld4d(2)=vecdim
        vbarid = ncvdef (ncoutid,'vbaro',vartyp,4,vfld4d(2),rcode)
        vfld4d(2)=olevdim
        wkstr = 'barotropic velocity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vbarid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vbarid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'barotropic velocity, vector, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vbarid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vbarid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,vbarid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,vbarid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define integrated (from surface: rigid lid) geostrophic shear
c  velocity
c
      if(iout(5).eq.1) then
        vgeoid = ncvdef (ncoutid,'vgeo',vartyp,5,vfld4d,rcode)
        wkstr = 'integrated geostrophic shear velocity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vgeoid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vgeoid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'integrated shear, vector, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vgeoid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vgeoid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,vgeoid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,vgeoid,'missing_value',vartyp,1,spval,rcode)
      endif
#ifdef ext_tide
c
c  Define tidal velocity
c
      if(iout(17).eq.1) then
        vtidid = ncvdef (ncoutid,'vtide',vartyp,5,vfld4d,rcode)
        wkstr = 'tidal velocity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vtidid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vtidid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tidal velocity, vector, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vtidid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vtidid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,vtidid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,vtidid,'missing_value',vartyp,1,spval,rcode)
      endif
#endif
c
c  Define topography-following vertical velocity at velocity points.
c
      if(iout(6).eq.1) then
        wvsvid = ncvdef (ncoutid,'wvsv',vartyp,4,vfld4d(2),rcode)
        wkstr = 's-coordinate vertical velocity at WV-points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvsvid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvsvid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'V_wvel s-coord, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvsvid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'wvgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvsvid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,wvsvid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,wvsvid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define topography-following vertical velocity at tracer points.
c
      if(iout(7).eq.1) then
        wvstid = ncvdef (ncoutid,'wvst',vartyp,4,tfld4d,rcode)
        wkstr = 's-coordinate vertical velocity at WT-points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvstid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvstid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'T_wvel s-coord, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvstid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'wtgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvstid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,wvstid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,wvstid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define vertical velocity at velocity points.
c
      if(iout(8).eq.1) then
        wvzvid = ncvdef (ncoutid,'wvzv',vartyp,4,vfld4d(2),rcode)
        wkstr = 'vertical velocity at WV-points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvzvid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvzvid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'V_wvel, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvzvid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvzvid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,wvzvid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,wvzvid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define vertical velocity at velocity points.
c
      if(iout(9).eq.1) then
        wvztid = ncvdef (ncoutid,'wvzt',vartyp,4,tfld4d,rcode)
        wkstr = 'vertical velocity at WT-points'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvztid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvztid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'T_wvel, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvztid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,wvztid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,wvztid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,wvztid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define time rate of change of barotropic vorticity.
c
      if(iout(11).eq.1) then
        qbarid = ncvdef (ncoutid,'qbar',vartyp,3,tfld4d(2),rcode)
        wkstr = 'time rate of change of barotropic vorticity'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qbarid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'second-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qbarid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'voticity, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qbarid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,qbarid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,qbarid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,qbarid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define density anomaly.
c
      if(iout(14).eq.1) then
        denaid = ncvdef (ncoutid,'dena',vartyp,4,tfld4d,rcode)
        wkstr = 'PE density anomaly (sigma-1000)'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,denaid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'kilogram meter-3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,denaid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'density, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,denaid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,denaid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,denaid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,denaid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define mixed layer depth.
c
      if((iout(16).eq.1).and.(mldopt.gt.0)) then
        mldid = ncvdef (ncoutid,'mld',vartyp,3,tfld4d(2),rcode)
        wkstr = 'mixed-layer depth'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,mldid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'meter'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,mldid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'mixed-layer, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,mldid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,mldid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,mldid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,mldid,'missing_value',vartyp,1,spval,rcode)
      endif
#ifdef ext_tide
c
c  Define tidal surface elevation.
c
      if(iout(18).eq.1) then
        stidid = ncvdef (ncoutid,'srftide',vartyp,3,tfld4d(2),rcode)
        wkstr = 'tidal surface elevation'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,stidid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'meter'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,stidid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tidal surface, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,stidid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,stidid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,stidid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,stidid,'missing_value',vartyp,1,spval,rcode)
      endif
# ifdef tide_zero
c
c  Define residual tidal stress tensor.
c
      if(iout(19).eq.1) then
        vfld4d(1)=tnsdim
        ttidid = ncvdef (ncoutid,'strsstide',vartyp,5,vfld4d,rcode)
        wkstr = 'residual tidal stress tensor'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,ttidid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'centimeter second-2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,ttidid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'UUx; VUy; UVx; VVy'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,ttidid,'tensor',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tidal stress, tensor, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,ttidid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,ttidid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,ttidid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,ttidid,'missing_value',vartyp,1,spval,rcode)
        vfld4d(1)=vecdim
      endif
# endif
#endif
c
c  Define temperature and salinity.
c
      do 10 m=1,2
        madd=11
        if(iout(m+madd).ne.0) then
          fldnam=tname(1,m)
          call length (fldnam,slen,sbgn,send)
          trcsid(m) = ncvdef (ncoutid,fldnam(sbgn:send),vartyp,4,tfld4d,
     *                        rcode)
          call length (tname(2,m),slen,sbgn,send)
          call ncaptc (ncoutid,trcsid(m),'long_name',ncchar,slen,
     *                 tname(2,m)(sbgn:send),rcode)
          call length (tname(3,m),slen,sbgn,send)
          call ncaptc (ncoutid,trcsid(m),'units',ncchar,slen,
     *                 tname(3,m)(sbgn:send),rcode)
          call length (tname(4,m),slen,sbgn,send)
          call ncaptc (ncoutid,trcsid(m),'field',ncchar,slen,
     *                 tname(4,m)(sbgn:send),rcode)
          wkstr = 'tgrid3'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,trcsid(m),'positions',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,trcsid(m),'_FillValue',vartyp,1,spval,
     *                rcode)
          call ncapt (ncoutid,trcsid(m),'missing_value',vartyp,1,spval,
     *                rcode)
        endif
  10  continue
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c
c  Define biological tracers.
c
      do 20 m=3,nt
        madd=-2
        if(ibiout(m+madd).ne.0) then
          fldnam=tname(1,m)
          call length (fldnam,slen,sbgn,send)
          trcsid(m) = ncvdef (ncoutid,fldnam(sbgn:send),vartyp,4,tfld4d,
     *                        rcode)
          call length (tname(2,m),slen,sbgn,send)
          call ncaptc (ncoutid,trcsid(m),'long_name',ncchar,slen,
     *                 tname(2,m)(sbgn:send),rcode)
          call length (tname(3,m),slen,sbgn,send)
          call ncaptc (ncoutid,trcsid(m),'units',ncchar,slen,
     *                 tname(3,m)(sbgn:send),rcode)
          call length (tname(4,m),slen,sbgn,send)
          call ncaptc (ncoutid,trcsid(m),'field',ncchar,slen,
     *                 tname(4,m)(sbgn:send),rcode)
          wkstr = 'tgrid3'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,trcsid(m),'positions',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,trcsid(m),'_FillValue',vartyp,1,spval,
     *                rcode)
          call ncapt (ncoutid,trcsid(m),'missing_value',vartyp,1,spval,
     *                rcode)
        endif
  20  continue
c
c  Define recycled NH4 production rate.
c
      if(ibiout(nt-2+1).eq.1) then
        nh4pid = ncvdef (ncoutid,'NH4pr',vartyp,4,tfld4d,rcode)
        wkstr = 'recycled NH4 production rate'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,nh4pid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'millimoles nitrogen meter-3 day-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,nh4pid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'NH4 production, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,nh4pid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,nh4pid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,nh4pid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,nh4pid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define new NO3 production rate.
c
      if(ibiout(nt-2+2).eq.1) then
        no3pid = ncvdef (ncoutid,'NO3pr',vartyp,4,tfld4d,rcode)
        wkstr = 'new NO3 production rate'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,no3pid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'millimoles nitrogen meter-3 day-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,no3pid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'NO3 production, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,no3pid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,no3pid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,no3pid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,no3pid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define zooplankton grazing rate of phytoplankton.
c
      if(ibiout(nt-2+3).eq.1) then
        zgrpid = ncvdef (ncoutid,'zgrphy',vartyp,4,tfld4d,rcode)
        wkstr = 'zooplankton grazing rate of phytoplankton'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgrpid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'millimoles nitrogen meter-3 day-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgrpid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'zoo-phyto grazing, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgrpid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgrpid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,zgrpid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,zgrpid,'missing_value',vartyp,1,spval,rcode)
      endif
#endif
#ifdef bioMcGillic
c
c  Define organic nitrogen export rate.
c
      if(ibiout(nt-2+4).eq.1) then
        exptid = ncvdef (ncoutid,'N-export',vartyp,4,tfld4d,rcode)
        wkstr = 'organic nitrogen export rate'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,exptid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'millimoles nitrogen meter-3 day-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,exptid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'N-export, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,exptid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,exptid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,exptid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,exptid,'missing_value',vartyp,1,spval,rcode)
      endif
#endif
#ifdef bioFasham
c
c  Define zooplankton grazing rate of bacteria.
c
      if(ibiout(nt-2+4).eq.1) then
        zgrbid = ncvdef (ncoutid,'zgrbac',vartyp,4,tfld4d,rcode)
        wkstr = 'zooplankton grazing rate of bacteria'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgrbid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'millimoles nitrogen meter-3 day-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgrbid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'zoo-bacteria grazing, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgrbid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgrbid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,zgrbid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,zgrbid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define zooplankton grazing rate of PON.
c
      if(ibiout(nt-2+5).eq.1) then
        zgroid = ncvdef (ncoutid,'zgrPON',vartyp,4,tfld4d,rcode)
        wkstr = 'zooplankton grazing rate of PON'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgroid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'millimoles nitrogen meter-3 day-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgroid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'zoo-PON grazing, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgroid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,zgroid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,zgroid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,zgroid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define bacteria uptake rate of NH4.
c
      if(ibiout(nt-2+6).eq.1) then
        bgrnid = ncvdef (ncoutid,'bgrNH4',vartyp,4,tfld4d,rcode)
        wkstr = 'bacteria uptake rate of NH4'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,bgrnid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'millimoles nitrogen meter-3 day-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,bgrnid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'bacteria-NH4 grazing, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,bgrnid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,bgrnid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,bgrnid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,bgrnid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define bacteria uptake rate of DON.
c
      if(ibiout(nt-2+7).eq.1) then
        bgrdid = ncvdef (ncoutid,'bgrDON',vartyp,4,tfld4d,rcode)
        wkstr = 'bacteria uptake rate of DON'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,bgrdid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'millimoles nitrogen meter-3 day-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,bgrdid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'bacteria-DON grazing, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,bgrdid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,bgrdid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,bgrdid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,bgrdid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Define the fast-sinking export rate at level interfaces.
c
      if(ibiout(nt-2+8).eq.1) then
        fpflid = ncvdef (ncoutid,'sink_flux',vartyp,4,tfld4d,rcode)
        wkstr = 'fast-sinking particle export flux'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,fpflid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'micromoles nitrogen meter-2 day-1'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,fpflid,'units',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'sinking flux, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,fpflid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'wtgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,fpflid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,fpflid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,fpflid,'missing_value',vartyp,1,spval,rcode)
      endif
#endif
#if defined oias & defined fcsterr
c
c  Define the forecast errors.
c
      if ((iout(21).ne.0).and.(iobserr.ne.0)) then
c
c       Define transport streamfunction forecast errors.
c
        pferid = ncvdef (ncoutid,'pbarferr',vartyp,3,tfld4d(2),rcode)
        wkstr = 'transport streamfunction forecast error'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pferid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'error transport, scalar, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pferid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'tgrid2'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,pferid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,pferid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,pferid,'missing_value',vartyp,1,spval,rcode)
c
c       Define internal velocity forecast errors.
c
        vferid = ncvdef (ncoutid,'vclinferr',vartyp,5,vfld4d,rcode)
        wkstr = 'baroclinic velocity forecast error'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vferid,'long_name',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'error baroclinic velocity, vector, series'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vferid,'field',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        wkstr = 'vgrid3'
        call length (wkstr,slen,sbgn,send)
        call ncaptc (ncoutid,vferid,'positions',ncchar,slen,
     *               wkstr(sbgn:send),rcode)
        call ncapt (ncoutid,vferid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncoutid,vferid,'missing_value',vartyp,1,spval,rcode)
c
c       Define tracer forecast errors.
c
        do 25 m=1,nt
          fldnam = tname(1,m)
          call length (fldnam,slen,sbgn,send)
          wkstr  = fldnam(sbgn:send)//'ferr'
          call length (wkstr,slen,sbgn,send)
          tferid(m) = ncvdef (ncoutid,wkstr(sbgn:send),vartyp,4,tfld4d,
     *                     rcode)
          call length (tname(2,m),slen,sbgn,send)
          wkstr  = tname(2,m)(sbgn:send)//' forecast error'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tferid(m),'long_name',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call length (tname(4,m),slen,sbgn,send)
          wkstr  = 'error '//tname(4,m)(sbgn:send)
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tferid(m),'field',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          wkstr  = 'tgrid3'
          call length (wkstr,slen,sbgn,send)
          call ncaptc (ncoutid,tferid(m),'positions',ncchar,slen,
     *                 wkstr(sbgn:send),rcode)
          call ncapt (ncoutid,tferid(m),'_FillValue',vartyp,1,spval,
     *                rcode)
          call ncapt (ncoutid,tferid(m),'missing_value',vartyp,1,spval,
     *                rcode)
  25    continue
      endif
#endif
c
c=======================================================================
c  Leave definition mode.  =============================================
c=======================================================================
c
      call ncendf(ncoutid,rcode)
      if(rcode.eq.0) then
         ncoutst = 2
        else
         write(stdout,910) outname
         call exitus('DEFOUT')
      endif
c
c=======================================================================
c  Create and define energy/diagnostics NetCDF file.  ==================
c=======================================================================
c
      call defnrg
c
c  Get IDs for geometry fields in energy/diagnostics NetCDF file.
c
#ifdef coast
      ntg2did=ncvid(ncnrgid,'tgrid2',rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'tgrid2'
      endif
      nvg2did=ncvid(ncnrgid,'vgrid2',rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'vgrid2'
      endif
#endif
      if((iout(15).ne.0).or.(iout(20).eq.1)) then
        ntg3did=ncvid(ncnrgid,'tgrid3',rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'tgrid3'
        endif
      endif
      if(iout(10).ne.0) then
        nvg3did=ncvid(ncnrgid,'vgrid3',rcode)
        if(rcode.ne.0) then
          write(stdout,920) 'vgrid3'
        endif
      endif
c
c=======================================================================
c  Write out titles and scalar variables into PE output NetCDF file.
c=======================================================================
c
c  Form titles.
c
      write(titlmdl(3),'(4i1)') (iopt(i),i=1,4)
      write(titlmdl(4),'(4i1)') iopt(7)
      write(titlmdl(7),'(4i1)') nordv,ntimv,nfrqv
      write(titlmdl(8),'(4i1)') nordt,ntimt,nfrqt
      write(titlmdl(10),'(a4)') codeid(5:8)
      write(titlmdl(11),'(a4)') codeid(9:12)
      write(titlmdl(12),'(a4)') codeid(13:16)
      write(titlmdl(13),'(a4)') codeid(17:20)
      write(titlmdl(14),'(a4)') codeid(21:24)
      write(titlmdl(15),'(a4)') codeid(25:28)
      write(titlmdl(16),'(a4)') codeid(29:32)
      write(titlmdl(17),'(a4)') codeid(33:36)
      write(titlmdl(18),'(a4)') codeid(37:40)
      write(titlmdl(19),'(a4)') codeid(41:44)
c
      write(titlebc(4),'(4i1)') (iopt(i),i=6,9)
      write(titlebc(5),'(4i1)') iopt(10)
      write(titlebc(10),'(a4)') codeid(5:8)
      write(titlebc(11),'(a4)') codeid(9:12)
      write(titlebc(12),'(a4)') codeid(13:16)
      write(titlebc(13),'(a4)') codeid(17:20)
      write(titlebc(14),'(a4)') codeid(21:24)
      write(titlebc(15),'(a4)') codeid(25:28)
      write(titlebc(16),'(a4)') codeid(29:32)
      write(titlebc(17),'(a4)') codeid(33:36)
      write(titlebc(18),'(a4)') codeid(37:40)
      write(titlebc(19),'(a4)') codeid(41:44)
c
c  Write out titles.
c
      varid=ncvid(ncoutid,'titlrun',rcode)
      call ncvptc(ncoutid,varid,1,80,titlrun,80,rcode)
      varid=ncvid(ncoutid,'titlmdl',rcode)
      call ncvptc(ncoutid,varid,1,80,titlmdl,80,rcode)
      varid=ncvid(ncoutid,'titlebc',rcode)
      call ncvptc(ncoutid,varid,1,80,titlebc,80,rcode)
      varid=ncvid(ncoutid,'runic',rcode)
      call ncvptc(ncoutid,varid,1,24,runic,24,rcode)
      varid=ncvid(ncoutid,'titleic',rcode)
      call ncvptc(ncoutid,varid,1,80,titleic,80,rcode)
c
c  Write out PE model parameters.
c
      varid=ncvid(ncoutid,'imt',rcode)
      call ncvpt1(ncoutid,varid,1,imt,rcode)
      varid=ncvid(ncoutid,'jmt',rcode)
      call ncvpt1(ncoutid,varid,1,jmt,rcode)
      varid=ncvid(ncoutid,'km',rcode)
      call ncvpt1(ncoutid,varid,1,km,rcode)
      varid=ncvid(ncoutid,'nt',rcode)
      call ncvpt1(ncoutid,varid,1,nt,rcode)
      varid=ncvid(ncoutid,'lseg',rcode)
      call ncvpt1(ncoutid,varid,1,lseg,rcode)
      varid=ncvid(ncoutid,'misle',rcode)
      call ncvpt1(ncoutid,varid,1,misle,rcode)
      varid=ncvid(ncoutid,'lbc',rcode)
      call ncvpt1(ncoutid,varid,1,lbc,rcode)
c
      varid=ncvid(ncoutid,'nfirst',rcode)
      call ncvpt1(ncoutid,varid,1,nfirst,rcode)
      varid=ncvid(ncoutid,'nlast',rcode)
      call ncvpt1(ncoutid,varid,1,nlast,rcode)
      varid=ncvid(ncoutid,'nnergy',rcode)
      call ncvpt1(ncoutid,varid,1,nnergy,rcode)
      varid=ncvid(ncoutid,'ntsout',rcode)
      call ncvpt1(ncoutid,varid,1,ntsout,rcode)
      varid=ncvid(ncoutid,'ntsi',rcode)
      call ncvpt1(ncoutid,varid,1,ntsi,rcode)
      varid=ncvid(ncoutid,'nmix',rcode)
      call ncvpt1(ncoutid,varid,1,nmix,rcode)
      varid=ncvid(ncoutid,'mxscan',rcode)
      call ncvpt1(ncoutid,varid,1,mxscan,rcode)
c
c  Write out horizontal and vertical viscosity parameters.
c
      varid=ncvid(ncoutid,'mixvel',rcode)
      call ncvpt1(ncoutid,varid,1,mixvel,rcode)
      varid=ncvid(ncoutid,'mixtrc',rcode)
      call ncvpt1(ncoutid,varid,1,mixtrc,rcode)
      varid=ncvid(ncoutid,'mixztd',rcode)
      call ncvpt1(ncoutid,varid,1,mixztd,rcode)
      varid=ncvid(ncoutid,'am',rcode)
      call ncvpt1(ncoutid,varid,1,am,rcode)
      varid=ncvid(ncoutid,'ah',rcode)
      call ncvpt1(ncoutid,varid,1,ah,rcode)
      varid=ncvid(ncoutid,'fkpm',rcode)
      call ncvpt1(ncoutid,varid,1,fkpm,rcode)
      varid=ncvid(ncoutid,'fkph',rcode)
      call ncvpt1(ncoutid,varid,1,fkph,rcode)
#ifdef shapiro
      varid=ncvid(ncoutid,'nordv',rcode)
      call ncvpt1(ncoutid,varid,1,nordv,rcode)
      varid=ncvid(ncoutid,'ntimv',rcode)
      call ncvpt1(ncoutid,varid,1,ntimv,rcode)
      varid=ncvid(ncoutid,'nfrqv',rcode)
      call ncvpt1(ncoutid,varid,1,nfrqv,rcode)
      varid=ncvid(ncoutid,'nordt',rcode)
      call ncvpt1(ncoutid,varid,1,nordt,rcode)
      varid=ncvid(ncoutid,'ntimt',rcode)
      call ncvpt1(ncoutid,varid,1,ntimt,rcode)
      varid=ncvid(ncoutid,'nfrqt',rcode)
      call ncvpt1(ncoutid,varid,1,nfrqt,rcode)
      varid=ncvid(ncoutid,'nordp',rcode)
      call ncvpt1(ncoutid,varid,1,nordp,rcode)
      varid=ncvid(ncoutid,'ntimp',rcode)
      call ncvpt1(ncoutid,varid,1,ntimp,rcode)
      varid=ncvid(ncoutid,'nfrqp',rcode)
      call ncvpt1(ncoutid,varid,1,nfrqp,rcode)
      varid=ncvid(ncoutid,'nordz',rcode)
      call ncvpt1(ncoutid,varid,1,nordz,rcode)
      varid=ncvid(ncoutid,'ntimz',rcode)
      call ncvpt1(ncoutid,varid,1,ntimz,rcode)
      varid=ncvid(ncoutid,'nfrqz',rcode)
      call ncvpt1(ncoutid,varid,1,nfrqz,rcode)
#endif
c
c  Write out time stepping parameters.
c
      varid=ncvid(ncoutid,'dtts',rcode)
      call ncvpt1(ncoutid,varid,1,dtts,rcode)
      varid=ncvid(ncoutid,'dtuv',rcode)
      call ncvpt1(ncoutid,varid,1,dtuv,rcode)
      varid=ncvid(ncoutid,'dtsf',rcode)
      call ncvpt1(ncoutid,varid,1,dtsf,rcode)
c
c  Write out relaxation and Coriolis treatment parameters.
c
      varid=ncvid(ncoutid,'sor',rcode)
      call ncvpt1(ncoutid,varid,1,sor,rcode)
      varid=ncvid(ncoutid,'crit',rcode)
      call ncvpt1(ncoutid,varid,1,crit,rcode)
      varid=ncvid(ncoutid,'acor',rcode)
      call ncvpt1(ncoutid,varid,1,acor,rcode)
c
c  Write out model domain parameters.
c
      varid=ncvid(ncoutid,'coord',rcode)
      call ncvpt1(ncoutid,varid,1,coord,rcode)
      varid=ncvid(ncoutid,'rlngd',rcode)
      call ncvpt1(ncoutid,varid,1,rlngd,rcode)
      varid=ncvid(ncoutid,'rlatd',rcode)
      call ncvpt1(ncoutid,varid,1,rlatd,rcode)
      varid=ncvid(ncoutid,'delx',rcode)
      call ncvpt1(ncoutid,varid,1,delx,rcode)
      varid=ncvid(ncoutid,'dely',rcode)
      call ncvpt1(ncoutid,varid,1,dely,rcode)
      varid=ncvid(ncoutid,'thetad',rcode)
      call ncvpt1(ncoutid,varid,1,thetad,rcode)
c
c  Write out equation of state for seawater parameters.
c
      varid=ncvid(ncoutid,'rho0',rcode)
      call ncvpt1(ncoutid,varid,1,rho0,rcode)
      varid=ncvid(ncoutid,'smean',rcode)
      call ncvpt1(ncoutid,varid,1,smean,rcode)
#ifdef leqstate
      varid=ncvid(ncoutid,'rbar',rcode)
      call ncvpt1(ncoutid,varid,1,rbar,rcode)
      varid=ncvid(ncoutid,'sbar',rcode)
      call ncvpt1(ncoutid,varid,1,sbar,rcode)
      varid=ncvid(ncoutid,'tbar',rcode)
      call ncvpt1(ncoutid,varid,1,tbar,rcode)
      varid=ncvid(ncoutid,'scoef',rcode)
      call ncvpt1(ncoutid,varid,1,scoef,rcode)
      varid=ncvid(ncoutid,'tcoef',rcode)
      call ncvpt1(ncoutid,varid,1,tcoef,rcode)
#endif
#ifdef dblsigma
c
c  Write out double vertical coordinate transformation parameters.
c
      varid=ncvid(ncoutid,'zc1',rcode)
      call ncvpt1(ncoutid,varid,1,zc1,rcode)
      varid=ncvid(ncoutid,'zc2',rcode)
      call ncvpt1(ncoutid,varid,1,zc2,rcode)
      varid=ncvid(ncoutid,'zref',rcode)
      call ncvpt1(ncoutid,varid,1,zref,rcode)
      varid=ncvid(ncoutid,'zslope',rcode)
      call ncvpt1(ncoutid,varid,1,zslope,rcode)
#endif
#ifdef bndy_rlx
c
c  Write out boundary relaxation parameters.
c
      varid=ncvid(ncoutid,'dvbrlx',rcode)
      call ncvpt1(ncoutid,varid,1,dvbrlx,rcode)
      varid=ncvid(ncoutid,'tvbrlx',rcode)
      call ncvpt1(ncoutid,varid,1,tvbrlx,rcode)
      varid=ncvid(ncoutid,'dtbrlx',rcode)
      call ncvpt1(ncoutid,varid,1,dtbrlx,rcode)
      varid=ncvid(ncoutid,'ttbrlx',rcode)
      call ncvpt1(ncoutid,varid,1,ttbrlx,rcode)
#endif
#ifdef cstfrc
c
c  Write out coastal friction parameters.
c
      varid=ncvid(ncoutid,'dcsfrc',rcode)
      call ncvpt1(ncoutid,varid,1,dcsfrc,rcode)
      varid=ncvid(ncoutid,'tcsfrc',rcode)
      call ncvpt1(ncoutid,varid,1,tcsfrc,rcode)
#endif
#ifdef botfrc
c
c  Write out bottom friction parameters.
c
      varid=ncvid(ncoutid,'dbtfrc',rcode)
      call ncvpt1(ncoutid,varid,1,dbtfrc,rcode)
      varid=ncvid(ncoutid,'tbtfrc',rcode)
      call ncvpt1(ncoutid,varid,1,tbtfrc,rcode)
#endif
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c
c  Write out biological model parameters
c
      call putbparm (ncoutid)
#endif
c
c=======================================================================
c  Write out flags, options and switches arrays into the NetCDF file.
c=======================================================================
c
      varid=ncvid(ncoutid,'iflag',rcode)
      start(1)=1
      count(1)=10
      call ncvpt(ncoutid,varid,start,count,iflag,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'iflag'
        call exitus('DEFOUT')
      endif
      varid=ncvid(ncoutid,'iopt',rcode)
      start(1)=1
      count(1)=10
      call ncvpt(ncoutid,varid,start,count,iopt,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'iopt'
        call exitus('DEFOUT')
      endif
      varid=ncvid(ncoutid,'iout',rcode)
      start(1)=1
      count(1)=20
      call ncvpt(ncoutid,varid,start,count,iout,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'iout'
        call exitus('DEFOUT')
      endif
#if defined bioAnder | defined bioFasham | defined bioMcGillic | defined bioDuse
      varid=ncvid(ncoutid,'ibiout',rcode)
      start(1)=1
      count(1)=20
      call ncvpt(ncoutid,varid,start,count,ibiout,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'ibiout'
        call exitus('DEFOUT')
      endif
#endif
      varid=ncvid(ncoutid,'outlev',rcode)
      start(1)=1
      count(1)=nlev
      call ncvpt(ncoutid,varid,start,count,lev,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'outlev'
        call exitus('DEFOUT')
      endif
c
c  Write out mean TS profile.
c
      start(1)=1
      count(1)=nprof
      varid=ncvid(ncoutid,'tclima',rcode)
      call ncvpt(ncoutid,varid,start,count,tinit(1,1),rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'tclima'
        call exitus('DEFOUT')
      endif
      varid=ncvid(ncoutid,'sclima',rcode)
      call ncvpt(ncoutid,varid,start,count,tinit(1,2),rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'sclima'
        call exitus('DEFOUT')
      endif
      varid=ncvid(ncoutid,'zclima',rcode)
      do 30 k=1,nprof
        work(k)=-cm2m*abs(tinit(k,3))
  30  continue
      call ncvpt(ncoutid,varid,start,count,work,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'zclima'
        call exitus('DEFOUT')
      endif
c
c=======================================================================
c  Write geometry variables into NetCDF file.
c=======================================================================
c
c  Write depths and thicknesses for the reference flat levels.
c
      do 40 k=1,km
        start(1)=k
        count(1)=1
        varid=ncvid(ncoutid,'refz',rcode)
        call ncvpt(ncoutid,varid,start,count,-abs(refz(k)*cm2m),rcode)
        if(rcode.ne.0) then
          write(stdout,930) 'refz'
          call exitus('DEFOUT')
        endif
        varid=ncvid(ncoutid,'hz',rcode)
        call ncvpt(ncoutid,varid,start,count,hz(k)*cm2m,rcode)
        if(rcode.ne.0) then
          write(stdout,930) 'hz'
          call exitus('DEFOUT')
        endif
  40  continue
c
c  Write out horizontal grid spacing between tracer points.
c
      varid=ncvid(ncoutid,'dxt',rcode)
      start(1)=1
      count(1)=imt
      call ncvpt(ncoutid,varid,start,count,dxt,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'dxt'
        call exitus('DEFOUT')
      endif
      varid=ncvid(ncoutid,'dyt',rcode)
      start(1)=1
      count(1)=jmt
      call ncvpt(ncoutid,varid,start,count,dyt,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'dyt'
        call exitus('DEFOUT')
      endif
c
c-----------------------------------------------------------------------
c  Write out positions at tracer and velocity points.
c-----------------------------------------------------------------------
c
c  Write (x,y) positions for 2D fields at tracer and velocity points.
c
      start(1)=xindx
      count(1)=1
      start(2)=1
      count(2)=imt
      start(3)=1
      count(3)=jmt
      call ncvpt(ncoutid,tg2did,start,count,tlon,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'tgrid2 x-axis'
        call exitus('DEFOUT')
      endif
      call ncvpt(ncoutid,vg2did,start,count,vlon,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'vgrid2 x-axis'
        call exitus('DEFOUT')
      endif
#ifdef coast
      call ncvpt(ncnrgid,ntg2did,start,count,tlon,rcode)
      if(rcode.ne.0) then
        write(stdout,940) 'tgrid2 x-axis'
        call exitus('DEFOUT')
      endif
      call ncvpt(ncnrgid,nvg2did,start,count,vlon,rcode)
      if(rcode.ne.0) then
        write(stdout,940) 'vgrid2 x-axis'
        call exitus('DEFOUT')
      endif
#endif
      start(1)=yindx
      count(1)=1
      call ncvpt(ncoutid,tg2did,start,count,tlat,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'tgrid2 y-axis'
        call exitus('DEFOUT')
      endif
      call ncvpt(ncoutid,vg2did,start,count,vlat,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'vgrid2 y-axis'
        call exitus('DEFOUT')
      endif
#ifdef coast
      call ncvpt(ncnrgid,ntg2did,start,count,tlat,rcode)
      if(rcode.ne.0) then
        write(stdout,940) 'tgrid2 y-axis'
        call exitus('DEFOUT')
      endif
      call ncvpt(ncnrgid,nvg2did,start,count,vlat,rcode)
      if(rcode.ne.0) then
        write(stdout,940) 'vgrid2 y-axis'
        call exitus('DEFOUT')
      endif
#endif
c
c  Write (x,y) positions for 3D fields at tracer and W-tracer points.
c  Use a volume data working array to minimize number IO calls.
c
      start(2)=1
      count(2)=nlev
      start(3)=1
      count(3)=imt
      start(4)=1
      count(4)=jmt
c
      ip=0
      do 50 j=1,jmt
      do 50 i=1,imt
      do 50 k=1,nlev
        ip=ip+1
        work(ip)=tlon(i,j)
  50  continue
      start(1)=xindx
      count(1)=1
      call ncvpt(ncoutid,tg3did,start,count,work,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'tgrid3 x-axis'
        call exitus('DEFOUT')
      endif
      if((iout(15).ne.0).or.(iout(20).eq.1)) then
        call ncvpt(ncnrgid,ntg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,940) 'tgrid3 x-axis'
          call exitus('DEFOUT')
        endif
      endif
#ifdef bioFasham
      if((iout(7).eq.1).or.(iout(9).eq.1).or.(ibiout(nt-2+8).eq.1)) then
#else
      if((iout(7).eq.1).or.(iout(9).eq.1)) then
#endif
        call ncvpt(ncoutid,wtg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,930) 'wtgrid3 x-axis'
          call exitus('DEFOUT')
        endif
      endif
c
      ip=0
      do 60 j=1,jmt
      do 60 i=1,imt
      do 60 k=1,nlev
        ip=ip+1
        work(ip)=tlat(i,j)
  60  continue
      start(1)=yindx
      count(1)=1
      call ncvpt(ncoutid,tg3did,start,count,work,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'tgrid3 y-axis'
        call exitus('DEFOUT')
      endif
      if((iout(15).ne.0).or.(iout(20).eq.1)) then
        call ncvpt(ncnrgid,ntg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,940) 'tgrid3 y-axis'
          call exitus('DEFOUT')
        endif
      endif
#ifdef bioFasham
      if((iout(7).eq.1).or.(iout(9).eq.1).or.(ibiout(nt-2+8).eq.1)) then
#else
      if((iout(7).eq.1).or.(iout(9).eq.1)) then
#endif
        call ncvpt(ncoutid,wtg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,930) 'wtgrid3 y-axis'
          call exitus('DEFOUT')
        endif
      endif
c
c  Write (x,y) positions for 3D fields at velocity and W-velocity points.
c  Use a volume data working array to minimize number IO calls.
c
      start(2)=1
      count(2)=nlev
      start(3)=1
      count(3)=imt
      start(4)=1
      count(4)=jmt
c
      ip=0
      do 70 j=1,jmt
      do 70 i=1,imt
      do 70 k=1,nlev
        ip=ip+1
        work(ip)=vlon(i,j)
  70  continue
      start(1)=xindx
      count(1)=1
      call ncvpt(ncoutid,vg3did,start,count,work,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'vgrid3 x-axis'
        call exitus('DEFOUT')
      endif
      if(iout(10).ne.0) then
        call ncvpt(ncnrgid,nvg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,940) 'vgrid3 x-axis'
          call exitus('DEFOUT')
        endif
      endif
      if((iout(6).eq.1).or.(iout(8).eq.1)) then
        call ncvpt(ncoutid,wvg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,930) 'wvgrid3 x-axis'
          call exitus('DEFOUT')
        endif
      endif
c
      ip=0
      do 80 j=1,jmt
      do 80 i=1,imt
      do 80 k=1,nlev
        ip=ip+1
        work(ip)=vlat(i,j)
  80  continue
      start(1)=yindx
      count(1)=1
      call ncvpt(ncoutid,vg3did,start,count,work,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'vgrid3 y-axis'
        call exitus('DEFOUT')
      endif
      if(iout(10).ne.0) then
        call ncvpt(ncnrgid,nvg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,940) 'vgrid3 y-axis'
          call exitus('DEFOUT')
        endif
      endif
      if((iout(6).eq.1).or.(iout(8).eq.1)) then
        call ncvpt(ncoutid,wvg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,930) 'wvgrid3 y-axis'
          call exitus('DEFOUT')
        endif
      endif
c
c  Write out bathymetry (meters) at the tracer points.
c
      ip=0
      do 90 j=1,jmt
      do 90 i=1,imt
        ip=ip+1
        work(ip)=-cm2m*abs(hd(i,j))
  90  continue
      start(1)=1
      count(1)=imt
      start(2)=1
      count(2)=jmt
      call ncvpt(ncoutid,tbthid,start,count,work,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'tbath'
        call exitus('DEFOUT')
      endif
c
c-----------------------------------------------------------------------
c  Write out depths (meters) at the center of the tracer and velocity
c  boxes into positional arrays.
c-----------------------------------------------------------------------
c
      start(1)=zindx
      count(1)=1
      start(2)=1
      count(2)=nlev
      start(3)=1
      count(3)=imt
      start(4)=1
      count(4)=jmt
c
c  Write out (z) positions for 3D fields tracer points.
c
      ip=0
      do 100 j=1,jmt
        call depthslab(j,tgrid,tdepth(1,1,0))
      do 100 i=1,imt
      do 100 k=1,nlev
        ip=ip+1
        klev=lev(k)
        if(klev.gt.km) then
          work(ip)=-FLoaT(klev)
        else
          work(ip)=-abs(tdepth(i,klev,0))*cm2m
        endif
 100  continue
      call ncvpt(ncoutid,tg3did,start,count,work,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'tgrid3 z-axis'
        call exitus('DEFOUT')
      endif
      if((iout(15).ne.0).or.(iout(20).eq.1)) then
        call ncvpt(ncnrgid,ntg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,940) 'tgrid3 z-axis'
          call exitus('DEFOUT')
        endif
      endif
c
c  Write out (z) positions for 3D fields W-tracer points.
c
#ifdef bioFasham
      if((iout(7).eq.1).or.(iout(9).eq.1).or.(ibiout(nt-2+8).eq.1)) then
#else
      if((iout(7).eq.1).or.(iout(9).eq.1)) then
#endif
        ip=0
        do 110 j=1,jmt
          call depthslab(j,tgrid,tdepth(1,1,0))
#ifdef gridold
          call get_thick(tdepth(1,1,0),dzqz(1,1,0),dzzqz(1,1,0),kmp1)
#else
          call get_thick (j,tgrid,dzqz(1,1,0),dzzqz(1,1,0),kmp1)
#endif
        do 110 i=1,imt
        do 110 k=1,nlev
          ip=ip+1
          klev=lev(k)
          if(klev.gt.km) then
            work(ip)=-FLoaT(klev)
          else
            work(ip)=-abs(tdepth(i,klev,0)+p5*dzqz(i,klev,0))*cm2m
          endif
 110    continue
        call ncvpt(ncoutid,wtg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,930) 'wtgrid3 z-axis'
          call exitus('DEFOUT')
        endif
      endif
c
c  Write out (z) positions for 3D fields velocity points.
c
      ip=0
      do 120 j=1,jmt
        call depthslab(j,vgrid,vdepth(1,1,0))
      do 120 i=1,imt
      do 120 k=1,nlev
        ip=ip+1
        klev=lev(k)
        if(klev.gt.km) then
          work(ip)=-FLoaT(klev)
        else
          work(ip)=-abs(vdepth(i,klev,0))*cm2m
        endif
 120  continue
      call ncvpt(ncoutid,vg3did,start,count,work,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'vgrid3 z-axis'
        call exitus('DEFOUT')
      endif
      if(iout(10).ne.0) then
        call ncvpt(ncnrgid,nvg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,940) 'vgrid3 z-axis'
          call exitus('DEFOUT')
        endif
      endif
c
c  Write out (z) positions for 3D fields W-velocity points.
c
      if((iout(6).eq.1).or.(iout(8).eq.1)) then
        ip=0
        do 130 j=1,jmt
          call depthslab(j,vgrid,vdepth(1,1,0))
#ifdef gridold
          call get_thick(vdepth(1,1,0),dzvqz(1,1,0),dzzvqz(1,1,0),kmp1)
#else
          call get_thick (j,vgrid,dzvqz(1,1,0),dzzvqz(1,1,0),kmp1)
#endif
        do 130 i=1,imt
        do 130 k=1,nlev
          ip=ip+1
          klev=lev(k)
          if(klev.gt.km) then
            work(ip)=-FLoaT(klev)
          else
            work(ip)=-abs(vdepth(i,klev,0)+p5*dzvqz(i,klev,0))*cm2m
          endif
 130    continue
        call ncvpt(ncoutid,wvg3did,start,count,work,rcode)
        if(rcode.ne.0) then
          write(stdout,930) 'wvgrid3 z-axis'
          call exitus('DEFOUT')
        endif
      endif
c
#ifdef coast
c-----------------------------------------------------------------------
c  Write out Land/Sea mask data at the tracer and velocity points into
c  output NetCDF files.
c-----------------------------------------------------------------------
c
      start(1)=1
      start(2)=1
      count(1)=imt
      count(2)=jmt
c
c  Write out land/sea mask fields to PE output NetCDF file.
c
      varid=ncvid(ncoutid,'landt',rcode)
      if(rcode.ne.0) then
        write(stdout,950) 'landt'
        call exitus('DEFOUT')
      endif
      call ncvpt(ncoutid,varid,start,count,landt,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'landt'
        call exitus('DEFOUT')
      endif
      varid=ncvid(ncoutid,'landv',rcode)
      if(rcode.ne.0) then
        write(stdout,950) 'landv'
        call exitus('DEFOUT')
      endif
      call ncvpt(ncoutid,varid,start,count,landv,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'landv'
        call exitus('DEFOUT')
      endif
c
c  Write out land/sea mask fields to energy/diagnostics NetCDF file.
c
      varid=ncvid(ncnrgid,'landt',rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'landt'
        call exitus('DEFOUT')
      endif
      call ncvpt(ncnrgid,varid,start,count,landt,rcode)
      if(rcode.ne.0) then
        write(stdout,940) 'landt'
        call exitus('DEFOUT')
      endif
      varid=ncvid(ncnrgid,'landv',rcode)
      if(rcode.ne.0) then
        write(stdout,920) 'landv'
        call exitus('DEFOUT')
      endif
      call ncvpt(ncnrgid,varid,start,count,landv,rcode)
      if(rcode.ne.0) then
        write(stdout,940) 'landv'
        call exitus('DEFOUT')
      endif
c
#endif
c-----------------------------------------------------------------------
c  Write 3D tracer and velocity box thicknesses.
c-----------------------------------------------------------------------
c
      start(1) = 1
      start(2) = 1
      count(1) = km
      count(2) = 1
      count(3) = 1
c
      varid = ncvid (ncoutid,'dzt',rcode)
      if (rcode.ne.0) then
         write(stdout,925) 'dzt'
         call exitus('DEFOUT')
      endif
      do 150 j = 1, jmt
         start(3) = j
#ifdef gridold
         call depthslab(j,tgrid,tdepth(1,1,0))
         call get_thick(tdepth(1,1,0),dzqz(1,1,0),dzzqz(1,1,0),kmp1)
#else
         call get_thick (j,tgrid,dzqz(1,1,0),dzzqz(1,1,0),kmp1)
#endif
         do 150 i = 1, imt
            start(2) = i
            do 140 k = 1, km
               work(k)=cm2m*dzqz(i,k,0)
 140        continue
            call ncvpt(ncoutid,varid,start,count,work,rcode)
            if (rcode.ne.0) then
               write(stdout,930) 'dzt'
               call exitus('DEFOUT')
            endif
 150  continue
c
      varid = ncvid (ncoutid,'dzv',rcode)
      if (rcode.ne.0) then
         write(stdout,925) 'dzv'
         call exitus('DEFOUT')
      endif
      do 170 j = 1, jmt
         start(3) = j
#ifdef gridold
         call depthslab(j,vgrid,vdepth(1,1,0))
         call get_thick(vdepth(1,1,0),dzvqz(1,1,0),dzzvqz(1,1,0),kmp1)
#else
         call get_thick (j,vgrid,dzvqz(1,1,0),dzzvqz(1,1,0),kmp1)
#endif
         do 170 i = 1, imt
            start(2) = i
            do 160 k = 1, km
               work(k)=cm2m*dzvqz(i,k,0)
 160        continue
            call ncvpt(ncoutid,varid,start,count,work,rcode)
            if (rcode.ne.0) then
               write(stdout,930) 'dzv'
               call exitus('DEFOUT')
            endif
 170  continue
c
 900  format(/' DEFOUT - unable to create PE output NetCDF file: ',a)
 910  format(/' DEFOUT - unable to define PE output NetCDF file: ',a)
 920  format(/' DEFOUT - undefined variable: ',a,2x,
     *        ' in energy/diagnostics output NetCDF file.')
 925  format(/' DEFOUT - undefined variable: ',a,2x,
     *        ' in PE output NetCDF file.')
 930  format(/' DEFOUT - error while writing variable: ',a,2x,
     *        ' into PE output NetCDF file.')
 940  format(/' DEFOUT - error while writing variable: ',a,2x,
     *        ' into energy output NetCDF file.')
 950  format(/' DEFOUT - undefined variable: ',a,2x,
     *        ' in PE output NetCDF file.')
 960  format ('(',1h','@(#)',1h',',a,',i2,'x,a,',1h',' updated on ',1h',
     *        ',a)')
      return
      end
