      subroutine impmxmn (ibgn,iend,jbgn,jend,usemin,minval,usemax,
     &                    maxval,fld)
c
c=======================================================================
c                                                                    ===
c  This routine limits the given field by the supplied values.       ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IBGN     Starting first index.          (integer)              ===
c     IEND     Ending first index.            (integer)              ===
c     JBGN     Starting second index.         (integer)              ===
c     JEND     Ending second index.           (integer)              ===
c     USEMIN   Use the given minimal limit.   (logical)              ===
c     MINVAL   Minimum valid value.           (real)                 ===
c     USEMAX   Use the given maximal limit.   (logical)              ===
c     MAXVAL   Maximum valid value.           (real)                 ===
c     FLD      Field to be limited.           (real array)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     FLD   Limited field.             (real array)                  ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ibgn,iend,j,jbgn,jend
      logical usemax,usemin
      real    maxval,minval
      real fld(ibgn:iend,jbgn:jend)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Apply minimum value.
c-----------------------------------------------------------------------
c
      if (usemin) then
         do 10 j = jbgn, jend
         do 10 i = ibgn, iend
            fld(i,j) =  max(fld(i,j) , minval)
  10     continue
      endif
c
c-----------------------------------------------------------------------
c  Apply maximum value.
c-----------------------------------------------------------------------
c
      if (usemax) then
         do 20 j = jbgn, jend
         do 20 i = ibgn, iend
            fld(i,j) =  min(fld(i,j) , maxval)
  20     continue
      endif
c
      return
      end
