      subroutine intatm (wtnew,iold,inew,time,taux,tauy,u10m,cldc,airt,
     &                   relh,sst,pres,prcp,wktime,wktaux,wktauy,wku10m,
     &                   wkcldc,wkairt,wkrelh,wksst,wkpres,wkprcp)
c
c=======================================================================
c                                                                    ===
c  This routine temporally interpolates atmospheric data.            ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     WTNEW  Weight applied to new data.  (real)                     ===
c     IOLD   Pointer to older data.       (integer)                  ===
c     INEW   Pointer to newer data.       (integer)                  ===
c     TIME   Time of data set.            (real; modified Julian day)===
c     TAUX   Zonal wind stress.           (real array; dynes/cm^2)   ===
c     TAUY   Meridional wind stress.      (real array; dynes/cm^2)   ===
c     U10M   10 meter wind speed.         (real array; m/s)          ===
c     CLDC   Fractional cloud cover.      (real array)               ===
c     AIRT   Air temperature.             (real array; celsius)      ===
c     RELH   Relative humidity.           (real array)               ===
c     SST    Sea surface temperature.     (real array; celsius)      ===
c     PRES   Surface pressure.            (real array; millibar)     ===
c     PRCP   Precipitation.               (real array; cm/day)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     WKTIME   Interpolated time.         (real; modified Julian day)===
c     WKTAUX   Zonal wind stress.         (real array; dynes/cm^2)   ===
c     WKTAUY   Meridional wind stress.    (real array; dynes/cm^2)   ===
c     WKU10M   10 meter wind speed.       (real array; m/s)          ===
c     WKCLDC   Fractional cloud cover.    (real array)               ===
c     WKAIRT   Air temperature.           (real array; celsius)      ===
c     WKRELH   Relative humidity.         (real array)               ===
c     WKSST    Sea surface temperature.   (real array; celsius)      ===
c     WKPRES   Surface pressure.          (real array; millibar)     ===
c     WKPRCP   Precipitation.             (real array; cm/day)       ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     none                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,iold,inew,j
      real    c1,wktime,wtnew,wtold
      real airt(nx,ny,0:1),cldc(nx,ny,0:1),prcp(nx,ny,0:1),
     &     pres(nx,ny,0:1),relh(nx,ny,0:1),sst(nx,ny,0:1),
     &     taux(nx,ny,0:1),tauy(nx,ny,0:1),time(0:1),u10m(nx,ny,0:1)
      real wkairt(nx,ny),wkcldc(nx,ny),wkprcp(nx,ny),wkpres(nx,ny),
     &     wkrelh(nx,ny),wksst(nx,ny),wktaux(nx,ny),wktauy(nx,ny),
     &     wku10m(nx,ny)
c
      parameter (c1=1.0)
c
c=======================================================================
c  Begin executable code
c=======================================================================
c
c-----------------------------------------------------------------------
c  Interpolate data.
c-----------------------------------------------------------------------
c
      wtold = c1 - wtnew
      wktime =  wtnew*time(inew) + wtold*time(iold)
c
      do j = 1, ny
         do i = 1, nx
            wkairt(i,j) = wtnew*airt(i,j,inew) + wtold*airt(i,j,iold)
            wkcldc(i,j) = wtnew*cldc(i,j,inew) + wtold*cldc(i,j,iold)
            wkprcp(i,j) = wtnew*prcp(i,j,inew) + wtold*prcp(i,j,iold)
            wkpres(i,j) = wtnew*pres(i,j,inew) + wtold*pres(i,j,iold)
            wkrelh(i,j) = wtnew*relh(i,j,inew) + wtold*relh(i,j,iold)
            wksst(i,j)  = wtnew*sst(i,j,inew)  + wtold*sst(i,j,iold)
            wktaux(i,j) = wtnew*taux(i,j,inew) + wtold*taux(i,j,iold)
            wktauy(i,j) = wtnew*tauy(i,j,inew) + wtold*tauy(i,j,iold)
            wku10m(i,j) = wtnew*u10m(i,j,inew) + wtold*u10m(i,j,iold)
         enddo
      enddo
c
      return
      end
