      subroutine read_frc (iout,time,taux,tauy,qnet,emp,swrd)
c
c=======================================================================
c                                                                    ===
c  This routine reads the forcings from the indicated files.         ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IOUT   Unit numbers for files.        (integer vector)         ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     TIME   Time for forcing.              (real; mod. Jul day)     ===
c     TAUX   Zonal wind stress.             (real array; dynes/cm^2) ===
c     TAUY   Meridional wind stress.        (real array; dynes/cm^2) ===
c     QNET   Net heat flux.                 (real array; W/m^2)      ===
c     EMP    Evaporation - precipitation.   (real array; cm/day)     ===
c     SWRD   Shortwave radiation.           (real array; W/m^2)      ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  none                                                              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j
      integer iout(5)
      real    time
      real emp(nx,ny),qnet(nx,ny),swrd(nx,ny),taux(nx,ny),tauy(nx,ny)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Read one time level worth of forcing data.
c-----------------------------------------------------------------------
c
c  Read wind stress
c
      read (iout(2),*) time
      read (iout(2),*) ((taux(i,j),i=1,nx),j=1,ny)
      read (iout(2),*) time
      read (iout(2),*) ((tauy(i,j),i=1,nx),j=1,ny)
c
c  Read heat flux 
c
      read (iout(3),*) time
      read (iout(3),*) ((qnet(i,j),i=1,nx),j=1,ny)
c
c  Read evaporation minus precipitation
c
      read (iout(4),*) time
      read (iout(4),*) ((emp(i,j),i=1,nx),j=1,ny)
c
c  Read shortwave radiation 
c
      read (iout(5),*) time
      read (iout(5),*) ((swrd(i,j),i=1,nx),j=1,ny)
c
      return
      end
