        subroutine read1(nx,ny,arry,fname,ifmt)
c reads 1-degree grid
        integer nx,ny
        integer ib,mx,mtx,ifmt,k,j,i
        real xlat1
        
        real arry(nx,ny)
        character*(*) fname
        character*2 a2
        character*5 a5
        character*79 head1,head2
        open(10,file=fname)
        if (ifmt.eq.1) then
          read(10,*) head1
          read(10,*) head2
        elseif (ifmt.eq.2) then
          read(10,302) head1
          read(10,*) head2
        endif
        mx=mod(nx,9)
        mtx=(nx-mx)/9
        ib=-9
        if (mtx.gt.0) then
          do k=1,mtx
            read(10,101) a5
            ib=ib+9
            do j=ny,1,-1
              read(10,103) xlat1,a2,(arry(i,j),i=ib+1,ib+9)
            enddo
            if (k.lt.mtx) read(10,*)
          enddo
        endif
        if (mx.gt.0) then
          if (mtx.gt.0) read(10,*)
          read(10,101) a5
          ib=ib+9
          do j=ny,1,-1
            read(10,103) xlat1,a2,(arry(i,j),i=ib+1,ib+mx)
          enddo
        endif
        close(10)
 101    format(a5,9(a3,f5.1))
 103    format(f4.1,a2,9f8.1)
 302    format(a61)
        return
        end

        subroutine read3(nx,ny,ispd,idir,fname,lat,lon)
        integer nx,ny,mx,mtx,ib,k,i,j
c reads wind data; also retrieves lat and lon of 1-degree grid
        real lon(nx),lat(ny)
        integer ispd(nx,ny),idir(nx,ny)
        character*(*) fname
c        character*3 a3(nx)
        character*3 a3
        character*2 a2
c        character*2 a21(nx)
        character*2 a21
        character*5 a5
        character*79 head1,head2
        open(10,file=fname)
        read(10,*) head1
        read(10,*) head2
        mx=mod(nx,9)
        mtx=(nx-mx)/9
        ib=-9
        if (mtx.gt.0) then
          do k=1,mtx
            ib=ib+9
            read(10,101) a5,(a3,lon(i),i=ib+1,ib+9)
            do j=ny,1,-1
              read(10,102) lat(j),a2,
     &                     (idir(i,j),a21,ispd(i,j),i=ib+1,ib+9)
            enddo
            if (k.lt.mtx) read(10,*)
          enddo
        endif
        if (mx.gt.0) then
          if (mtx.gt.0) read(10,*)
          ib=ib+9
          read(10,101) a5,(a3,lon(i),i=ib+1,ib+mx)
          do j=ny,1,-1
            read(10,102) lat(j),a2,
     &                     (idir(i,j),a21,ispd(i,j),i=ib+1,ib+mx)
          enddo
        endif
        if (a3.eq.'W  ') then
          do i=1,nx 
            lon(i)=-lon(i) 
          enddo 
        endif 
        close(10)
 101    format(a5,9(a3,f5.1))
 102    format(f4.1,a2,9(i4,a2,i2))
        return
        end


        subroutine read2(nx3a,nx3b,ny3a,ny3b,arry,fname,ifmt)
	integer nx3a,nx3b,ny3a,ny3b,ifmt
        integer mtx,k,mx,nnx,ib,k,i,j,nny
        real xlat1
c reads 2-degree grid
        real arry(nx3a:nx3b,ny3a:ny3b)
        character*(*) fname
        character*2 a2
        character*5 a5
        character*79 head1,head2
        nnx=1+(nx3b-nx3a)/2
        nny=1+(ny3b-ny3a)/2
        open(10,file=fname)
        if (ifmt.eq.1) then
          read(10,*) head1
          read(10,*) head2
        elseif (ifmt.eq.2) then
          read(10,302) head1
          read(10,*) head2
        endif
        mx=mod(nnx,9)
        mtx=(nnx-mx)/9
        ib=-18+nx3a
        if (mtx.gt.0) then
          do k=1,mtx
            read(10,101) a5
            ib=ib+18
            do j=ny3b,ny3a,-2
              read(10,103) xlat1,a2,(arry(i,j),i=ib,ib+16,2)
            enddo
            if (k.lt.mtx) read(10,*)
          enddo
        endif
        if (mx.gt.0) then
          if (mtx.gt.0) read(10,*)
          read(10,101) a5
          ib=ib+18
          do j=ny3b,ny3a,-2
            read(10,103) xlat1,a2,(arry(i,j),i=ib,ib+2*(mx-1),2)
          enddo
        endif
        close(10)
c interpolate from 2-degree grid to 1-degree grid
        do i=nx3a,nx3b,2
        do j=ny3a+1,ny3b-1,2
          arry(i,j)=.5*(arry(i,j-1)+arry(i,j+1))
        enddo
        enddo
        do j=ny3a,ny3b
        do i=nx3a+1,nx3b-1,2
          arry(i,j)=.5*(arry(i-1,j)+arry(i+1,j))
        enddo
        enddo
 101    format(a5,9(a3,f5.1))
 103    format(f4.1,a2,9f8.1)
 302    format(a61)
        return
        end
 

