      subroutine shift_fld (ibgn,iend,jbgn,jend,shft,fld)
c
c=======================================================================
c                                                                    ===
c  This routine shifts the given field by the supplied value.        ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IBGN  Starting first index.      (integer)                     ===
c     IEND  Ending first index.        (integer)                     ===
c     JBGN  Starting second index.     (integer)                     ===
c     JEND  Ending second index.       (integer)                     ===
c     SHFT  Additive shifting value.   (real)                        ===
c     FLD   Field to be scaled.        (real array)                  ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     FLD   Shifted field.             (real array)                  ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ibgn,iend,j,jbgn,jend
      real shft
      real fld(ibgn:iend,jbgn:jend)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 10 j = jbgn, jend
      do 10 i = ibgn, iend
         fld(i,j) =  fld(i,j) + shft
  10  continue
c
      return
      end
