      subroutine shortwave (time,lon,lat,cldc,swrd)
c
c=======================================================================
c                                                                    ===
c  This routine computes short wave radiation.                       ===
c  from Peixoto and Oort, 1992, p 99                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
# include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,iday,imonth,itime,iyday,iyear,j
      real decl,deg2rad,dfrac,fd,h,pi,s0,swrad,time,x,xlat,yearday
      real lon(nx),lat(ny),cldc(nx,ny),swrd(nx,ny)
c
c   s0 is the solar constant in W/m2
c
      parameter (pi=3.14159265358979323846, deg2rad=pi/180.0, s0=1360.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c----------------------------------------------------------------------
c  Find yearday
c----------------------------------------------------------------------
c
      itime = int(time)
      dfrac = time - real(itime)
      itime = itime + 2440000
c
      call gregorian (itime,iday,imonth,iyear,iyday)
c
      yearday = real(iyday) + dfrac
c
c----------------------------------------------------------------------
c  Compute timing values
c----------------------------------------------------------------------
c
c   Declination in radians, assuming -23.45 on Dec 21
c
      decl = -23.45*cos(2.*pi*(355.-yearday)/365.)*deg2rad
c
c   Approx effect of Sun-earth distance, assuming closest on Jan 6
c
      fd = 1. + .035*cos(2.*pi*(6.-yearday)/365.)
c
c----------------------------------------------------------------------
c  Compute solar radiation field
c----------------------------------------------------------------------
c
      do j=1,ny
c
c  Determine daylight hour angle.  Avoiding the poles like the plague.
c
         xlat = lat(j)
         xlat = max(min(89.,xlat),-89.)*deg2rad
         x = -1.* tan(xlat)*tan(decl)
         x = max(min(1.,x),-1.)
         h = acos(x)
c
#ifndef dailyavg
         do i=1,nx
c
c  Compute the local solar noon (fraction of day) assuming that along
c  prime meridian, solar noon occurs at 1200z.
c
            x = 0.5 - lon(i)/360.0
c
c  Compute the local hour angle.
c
            x = (x-dfrac)*2.0*pi
            x = atan2(sin(x),cos(x))
c
c  Compute instantaneous flux in W m-2
c
            if (abs(x).lt.h) then
               swrad = s0*fd*
     &                 (sin(xlat)*sin(decl)+cos(xlat)*cos(decl)*cos(x))
#else
c  Compute daily averaged flux in W m-2 day-1
c
               swrad = s0*fd/pi*
     &                (h*sin(xlat)*sin(decl)+cos(xlat)*cos(decl)*sin(h))
#endif
               swrad = max(0.,swrad)
c
c   now assume cloud-free atmospheric absorption and reflection (including 
c   reflection at the sea surface) gives a mean transmission of 76%:
c   (Pond and Picard say 70%; Peixoto and Oort say 76%; for a mean cloud 
c   cover of 50%, 76% cloud-free transmission gives 49% total transmission)
c
               swrad = swrad*0.76
c
c   now take into account effect of local cloud cover
c
#ifdef dailyavg
         do i=1,nx
#endif
               swrd(i,j) = swrad*(1.-0.7*cldc(i,j))
c
#ifndef dailyavg
            else
               swrd(i,j) = 0.0
            endif
c
#endif
         enddo
      enddo
c
      return
      end
