      subroutine read_frc (iout,time,taux,tauy)
c
c=======================================================================
c                                                                    ===
c  This routine reads the forcings from the indicated files.         ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IOUT   Unit numbers for files.        (integer vector)         ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     TIME   Time for forcing.              (real; mod. Jul day)     ===
c     TAUX   Zonal wind stress.             (real array; dynes/cm^2) ===
c     TAUY   Meridional wind stress.        (real array; dynes/cm^2) ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  none                                                              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j
      integer iout(5)
      real    time
      real taux(nx,ny),tauy(nx,ny)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Read one time level worth of forcing data.
c-----------------------------------------------------------------------
c
c  Read wind stress
c
      read (iout(2),*) time
      read (iout(2),*) ((taux(i,j),i=1,nx),j=1,ny)
      read (iout(2),*) time
      read (iout(2),*) ((tauy(i,j),i=1,nx),j=1,ny)
c
      return
      end
