      subroutine set_out (iout,iscr,ntim,lon,lat,outfile)
c
c=======================================================================
c                                                                    ===
c  This file gets the run parameters.                                ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IOUT      Unit numbers for output files.      (integer vector) ===
c     ISCR      Unit numbers for scratch files.     (integer vector) ===
c     NTIM      Number of time levels to process.   (integer)        ===
c     LON       Forcing longitudes.                 (real vector)    ===
c     LAT       Forcing latitudes.                  (real vector)    ===
c     OUTFILE   Names for output files.             (string vector)  ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  none                                                              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,n,ntim
      integer iout(5),iscr(5)
      real         lat(ny),lon(nx)
      character*80 outfile(5)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Open forcing output files.  Write header data.
c-----------------------------------------------------------------------
c
      do 10 n = 2, 2
         open (iout(n), file=outfile(n), status='unknown')
         write (iout(n),*) ntim,nx,ny
         write (iout(n),*) (lon(i),i=1,nx)
         write (iout(n),*) (lat(j),j=1,ny)
  10  continue
c
c-----------------------------------------------------------------------
c  Rewind scratch files.
c-----------------------------------------------------------------------
c
      do 20 n = 2, 2
         rewind (iscr(n))
  20  continue
c
      return
      end
