      subroutine wrt_frc (iout,time,taux,tauy)
c
c=======================================================================
c                                                                    ===
c  This routine writes the forcings to the indicated files.          ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IOUT   Unit numbers for files.        (integer vector)         ===
c     TIME   Time for forcing.              (real; mod. Jul day)     ===
c     TAUX   Zonal wind stress.             (real array; dynes/cm^2) ===
c     TAUY   Meridional wind stress.        (real array; dynes/cm^2) ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  none                                                              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j
      integer iout(5)
      real    time
      real taux(nx,ny),tauy(nx,ny)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Write one time level worth of forcing data.
c-----------------------------------------------------------------------
c
c  Write wind stress
c
      write(iout(2),10) time
  10  format (1x,f12.5)
      write(iout(2),*) ((taux(i,j),i=1,nx),j=1,ny)
      write(iout(2),10) time
      write(iout(2),*) ((tauy(i,j),i=1,nx),j=1,ny)
c
      return
      end
