      subroutine cloud_scale (cldc,scale)
c
c=======================================================================
c                                                                    ===
c  This routine determines the scaling to be applied to the cloud    ===
c  cover.                                                            ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     CLDFILE   Name of input cloud data file.   (string)            ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     SCALE     Cloud scaling factor.            (real)              ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
# include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      real scale
      real cldc(nx,ny)
#ifdef guesscloud
      real    cloudmax
      integer cldpwr,i,j
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  convert to fraction; converted GRIB data appears to be in percent
c-----------------------------------------------------------------------
c
#ifdef normcr
      scale = 1.0
#else
      scale = 0.01
#endif
c
#ifdef guesscloud
c-----------------------------------------------------------------------
c  A FNMOC has changed without warning before.
c-----------------------------------------------------------------------
c
      cloudmax = 0.0
      do i=1,nx
      do j=1,ny
         cloudmax = max(cloudmax, cldc(i,j))
      enddo
      enddo
c
      if (cloudmax.gt.0.0) then
         cldpwr = int(log10(cloudmax))+1
         scale = 10.0**(-float(cldpwr))
      end if
c
#endif
      return
      end
