      subroutine get_parm (iout,iscr,iheat,ndays,outfile)
c
c=======================================================================
c                                                                    ===
c  This file gets the run parameters.                                ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IOUT      Unit numbers for output files.      (integer vector) ===
c     ISCR      Unit numbers for scratch files.     (integer vector) ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     IHEAT     Flag for writing heat components.   (integer)        ===
c                  [0]  do not write components                      ===
c                  [1]  write heat components                        ===
c     NDAYS     Number of time levels to process.   (integer)        ===
c     OUTFILE   Names for output files.             (string vector)  ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  none                                                              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer idum,iheat,ndays
      integer      iout(5),iscr(5)
      character*80 outfile(5)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Read global run parameters.
c-----------------------------------------------------------------------
c
c  Read ascii output filename.
c
      read (5,*) idum
      read (5,*) outfile(1)
c
c  Read name of output file for wind stress.
c
      read (5,*) idum
      read (5,*) outfile(2)
c
c  Read name of output file for net heat flux.
c
      read (5,*) idum
      read (5,*) outfile(3)
c
c  Read name of output file for surface water flux.
c
      read (5,*) idum
      read (5,*) outfile(4)
c
c  Read name of output file for shortwave radiation.
c
      read (5,*) idum
      read (5,*) outfile(5)
c
c  Read flag to write heat flux components: [0]=no, [1]=yes
c
      read (5,*) idum
      read (5,*) iheat
c
c  Read number of days to process.
c
      read (5,*) idum
      read (5,*) ndays
c
c-----------------------------------------------------------------------
c  Open some files.
c-----------------------------------------------------------------------
c
c  Open ascii output file.
c
      open (iout(1), file=outfile(1), status='unknown')
c
c  Open scratch files.
c
      do 10 idum = 2, 5
         open (iscr(idum), status='scratch')
  10  continue
c
      return
      end
