      subroutine maxabs (nx,ldf,ny,fld,mxfld)
c
c=======================================================================
c                                                                    ===
c  This routine finds the maximum absolute value of the given field. ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NX     Number of points in X-direction.       (integer)        ===
c     LDF    Leading dimension of FLD.              (integer)        ===
c     NY     Number of points in Y-direction.       (integer)        ===
c     FLD    Current field.                         (real array)     ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     MFLD   Maximum absolute value of field.       (real array)     ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,ldf,nx,ny
      real    mxfld
      real    fld(ldf,ny)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      mxfld = abs(fld(1,1))
c
      do 10 j = 1, ny
      do 10 i = 1, nx
         mxfld = max(abs(fld(i,j)), mxfld)
  10  continue
c
      return
      end
