      subroutine push_clm (ibgn,iend,jbgn,jend,mfld,fld)
c
c=======================================================================
c                                                                    ===
c  This routine pushes the mean field onto the current field.        ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IBGN   Starting leading index.                (integer)        ===
c     IEND   Ending leading index.                  (integer)        ===
c     JBGN   Starting second index.                 (integer)        ===
c     JEND   Ending second index.                   (integer)        ===
c     NDAY   Number of fields.                      (integer)        ===
c     MFLD   Mean field.                            (real array)     ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     FLD    Current field.                         (real array)     ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ibgn,iend,j,jbgn,jend
      real    fld(ibgn:iend,jbgn:jend),mfld(ibgn:iend,jbgn:jend)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 10 j = jbgn, jend
      do 10 i = ibgn, iend
         fld(i,j) = mfld(i,j)
  10  continue
c
      return
      end
