      subroutine setfmt (fldwd,value,fmt)
c
c=======================================================================
c                                                                    ===
c  This routine sets the format to write the given real value.       ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     FLDWD   Field width for writing.              (integer)        ===
c     value   Value to write.                       (real)           ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     fmt    Format to write value.                 (string)         ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer fldwd,infront,pwr
      real          aval,value
      character*(*) fmt
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Work with magnitude.
c-----------------------------------------------------------------------
c
      aval = abs(value)
c
c-----------------------------------------------------------------------
c  Zero is special
c-----------------------------------------------------------------------
c
      if (aval.eq.0.0) then
         fmt = 'f4.1'
         return
      endif
c
c-----------------------------------------------------------------------
c  General case
c-----------------------------------------------------------------------
c
c  Determine number of digits in front of the decimal
c
      infront = max(int(log10(aval))+1, 1)
c
c  Small numbers always get exponential
c
      pwr = max(-2, 3-fldwd)
c
c  If neither too large or small, write in floating point format.
c  Otherwise write in exponential format.
c
      if ( ((infront+2).le.fldwd) .and. (aval.ge.(10.0**pwr)) ) then
         write (fmt,10) fldwd,fldwd-(infront+2)
  10     format ('f',i2.2,'.',i2.2)
       else
         write (fmt,20) fldwd,fldwd-7
  20     format ('1pe',i2.2,'.',i2.2)
      endif
c
      return
      end
