      subroutine windstress (velx,vely,taux,tauy,u10m)
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j
      real    cd,rair,scalefac
      real taux(nx,ny),tauy(nx,ny),u10m(nx,ny),velx(nx,ny),vely(nx,ny)
c
c constants (in MKS) are from Pond & Picard, p 108
c
      parameter (cd=0.0014, rair=1.3, scalefac=10.0*cd*rair)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c----------------------------------------------------------------------
c  compute wind stress
c----------------------------------------------------------------------
c
c now convert wind velocity (m/s) and into
c wind stress (dynes/cm2)
c
      do i=1,nx
      do j=1,ny
         u10m(i,j) = sqrt(velx(i,j)*velx(i,j) + vely(i,j)*vely(i,j))
#ifndef pjhstress
         taux(i,j) = scalefac*sign(velx(i,j)*velx(i,j),velx(i,j))
         tauy(i,j) = scalefac*sign(vely(i,j)*vely(i,j),vely(i,j))
#else
         taux(i,j) = scalefac*velx(i,j)*u10m(i,j)
         tauy(i,j) = scalefac*vely(i,j)*u10m(i,j)
#endif
      enddo
      enddo
c
      return
      end
