      program aladwind

c  calculates pemodel fluxes from FNOC data
c this assumes the 2-degree grid encompasses the 1-degree grid 
c note that longitudes will not be right if goes from positive to negative
c (fix this by just reading the first lon?)
c
#include <param.h>
c 
c  Larry Anderson, Feb 1997
c
c to do: check for other formulas, in Peixoto and Oort, and Picard & Emery
c to do: check to make sure all values seem reasonable!
c are the FNOC values instantaneous, or time averages? which use?
c
      integer mxclm,mclmfil
      real      dt,rearth
      parameter (mclmfil=9*nx*ny, mxclm=2, dt=1.0/24.0, rearth=6371.315)
c
      real deg2rad,dlat,dlon,lat0,latc,lon0,lonc,pi,rad2deg,wktime,wtnew
#ifdef makeclimo
     &     ,wtold
#endif
      real airt(nx,ny,0:1),cldc(nx,ny,0:1),emp(nx,ny),evap(nx,ny),
     &     lat(ny),lon(nx),prcp(nx,ny,0:1),pres(nx,ny,0:1),qnet(nx,ny),
     &     relh(nx,ny,0:1),sst(nx,ny,0:1),swrd(nx,ny),taux(nx,ny,0:1),
     &     tauy(nx,ny,0:1),time(0:1),u10m(nx,ny,0:1),wkairt(nx,ny),
     &     wkcldc(nx,ny),wkprcp(nx,ny),wkpres(nx,ny),wkrelh(nx,ny),
     &     wksst(nx,ny),wktaux(nx,ny),wktauy(nx,ny),wku10m(nx,ny)
#ifdef makeclimo
     &     ,tclm(mxclm),mairt(nx,ny),mcldc(nx,ny),mprcp(nx,ny),
     &      mpres(nx,ny),mrelh(nx,ny),msst(nx,ny),mtaux(nx,ny),
     &        mtauy(nx,ny),mu10m(nx,ny)
#endif
      integer i,iheat,inew,inum,iold,j,ndays,nref,ntot
#ifdef makeclimo
     &        ,nclm
#endif
#ifdef sunfpe
     &        ,ieeer,my_handler,ieee_handler
#endif
      integer      iout(5),iscr(5)
      character*80 outfile(5)
c
#ifdef sunfpe
      external my_handler
c
#endif
      data inew,iold /1,0/
      data iout /20,21,22,23,24/
      data iscr /30,31,32,33,34/
#ifdef makeclimo
      data nclm /1/
      data tclm /1.0,8.0/
      data mairt,mprcp,mpres,msst,
     &     mtaux,mtauy,mu10m,mcldc,mrelh /mclmfil*0.0/
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef sunfpe
c-----------------------------------------------------------------------
c  Enable floating point error flags.
c-----------------------------------------------------------------------
c
      ieeer = ieee_handler ('set','common',my_handler)
      if (ieeer .ne. 0) write (6,900)
c
#endif
c-----------------------------------------------------------------------
c  Temporarily hardwire the latitudes & longitudes.
c-----------------------------------------------------------------------
c
      pi      = acos(-1.0)
      rad2deg = 180.0/pi
      deg2rad = pi/180.0
c
      lat0 = 38.998000
      dlat = (8.000000/rearth)*rad2deg
      do j=1,ny
         lat(j)=lat0+float(j-1)*dlat
      enddo
c
      lon0 = 5.248000
      dlon = (7.999000/(rearth*cos(lat0*deg2rad)))*rad2deg
      lonc=lon0+float(nx+1)*dlon/2
      latc=lat0+float(ny+1)*dlat/2
      dlon = (7.999000/(rearth*cos(latc*deg2rad)))*rad2deg
      lon0=lonc-float(nx+1)*dlon/2
      do i=1,nx
         lon(i)=lon0+float(i-1)*dlon
      enddo
c
c-----------------------------------------------------------------------
c  Get run parameters.
c-----------------------------------------------------------------------
c
      call get_parm (iout,iscr,ndays,outfile)
c
c-----------------------------------------------------------------------
c  Process first day.
c-----------------------------------------------------------------------
c
c  Read first day
c
      call get_data (iout(1),time(inew),taux(1,1,inew),tauy(1,1,inew))
#ifdef makeclimo
      call run_avg (1,nx,1,ny,ndays,taux(1,1,inew),mtaux)
      call run_avg (1,nx,1,ny,ndays,tauy(1,1,inew),mtauy)
#endif
c
c  Write first day forcings
c
      ntot = 1
      call wrt_frc (iscr,time(inew),taux(1,1,inew),tauy(1,1,inew))
c
c-----------------------------------------------------------------------
c  Process remaining days.
c-----------------------------------------------------------------------
c
      do inum = 2, ndays
c
c  Read next day
c
         iold = inew
         inew = 1 - inew
         call get_data(iout(1),time(inew),taux(1,1,inew),tauy(1,1,inew))
#ifdef makeclimo
         call run_avg (1,nx,1,ny,ndays,taux(1,1,inew),mtaux)
         call run_avg (1,nx,1,ny,ndays,tauy(1,1,inew),mtauy)
#endif
         ntot = ntot + 1
         call wrt_frc (iscr,time(inew),taux(1,1,inew),tauy(1,1,inew))
c
      enddo
c
c  Write global diagnostic statistics.
c
      call glbstat (iout(1))
c
#ifdef makeclimo
c-----------------------------------------------------------------------
c  Add first climatology cycle.
c-----------------------------------------------------------------------
c
c  Push climatology at first time
c
      iold = inew
      inew = 1 - inew
      time(inew) = time(iold) + tclm(1)
      call push_clm (1,nx,1,ny,mtaux,taux(1,1,inew))
      call push_clm (1,nx,1,ny,mtauy,tauy(1,1,inew))
c
c  Determine number of refining steps
c
      nref = nint((time(inew)-time(iold))/dt)
c
# ifndef dailyavg
c  Create forcings on refined grid
c
      do i = 1, nref
c
# endif
c    Interpolate atmospheric data.
c
# ifndef dailyavg
         wtnew = real(i)/real(nref)
# else
         wtnew = 1.0
# endif
         call intatm (wtnew,iold,inew,time,taux,tauy,u10m,cldc,airt,
     &                relh,sst,pres,prcp,wktime,wktaux,wktauy,wku10m,
     &                wkcldc,wkairt,wkrelh,wksst,wkpres,wkprcp)
c
c    Process interpolated forcings
c
         call shortwave (wktime,lon,lat,wkcldc,swrd)
         call net_heat (swrd,wku10m,wkairt,wkrelh,wksst,wkpres,
     &                     wkcldc,qnet,evap)
         call evap_precip (evap,wkprcp,emp)
c
c    Write interpolated forcings
c
         ntot = ntot + 1
         call wrt_frc (iscr,wktime,wktaux,wktauy)
c
# ifndef dailyavg
      enddo
c
# endif
c-----------------------------------------------------------------------
c  Remaining remaining climatology days.
c-----------------------------------------------------------------------
c
      do inum = 2, nclm
c
c  Determine number of refining steps
c
         nref = nint((tclm(inum)-tclm(inum-1))/dt)
c
# ifndef dailyavg
c  Create forcings on refined grid
c
         do i = 1, nref
c
# endif
c    Find new time.
c
# ifndef dailyavg
            wtnew = real(i)/real(nref)
            wtold = 1.0 - wtnew
# else
            wtnew = 1.0
            wtold = 0.0
# endif
            wktime=time(iold) + (wtnew*tclm(inum)+wtold*tclm(inum-1))
c
c    Process climatology forcings
c
            call shortwave (wktime,lon,lat,mcldc,swrd)
            call net_heat (swrd,mu10m,mairt,mrelh,msst,mpres,
     &                        mcldc,qnet,evap)
            call evap_precip (evap,mprcp,emp)
c
c    Write climatology forcings
c
            ntot = ntot + 1
            call wrt_frc (iscr,wktime,mtaux,mtauy,qnet,emp,swrd)
c
# ifndef dailyavg
         enddo
# endif
      enddo
c
#endif
c---------------------------------------------------------------------- 
c  Set up for writing final output files.
c----------------------------------------------------------------------
c
      call set_out (iout,iscr,ntot,lon,lat,outfile)
c
c---------------------------------------------------------------------- 
c  Copy forcings from scratch files to final output files.
c----------------------------------------------------------------------
c
      do inum = 1, ntot
         call read_frc (iscr,wktime,wktaux,wktauy)
         call wrt_frc  (iout,wktime,wktaux,wktauy)
      enddo
c
c---------------------------------------------------------------------- 
c  Close files.
c----------------------------------------------------------------------
c
      do inum = 1, 2
         close (iout(inum))
      enddo
c
      do inum = 2, 2
         close (iscr(inum))
      enddo
c
      stop
#ifdef sunfpe
 900  format (/'+++ Warning:  ieee_handler cannot set my_handler'/)
#endif
      end


