      subroutine getname (path,idanl,idfct,hour,day,month,year,fname,
     &                    fnd)
c
c=======================================================================
c                                                                    ===
c  This routine tries to find a FNMOC file corresponding to the      ===
c  given requirements, or the closest available file.                ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     PATH     Basic directory path.                  (string)       ===
c     IDANL    Identifier for FNMOC analysis field.   (string)       ===
c     IDFCT    Identifier for FNMOC forecast field.   (string)       ===
c     HOUR     Hour  (0, 12) for FNMOC data.          (integer)      ===
c     DAY      Day for FNMOC data.                    (integer)      ===
c     MONTH    Month for FNMOC data.                  (integer)      ===
c     YEAR     Year for FNMOC data.                   (integer)      ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     FNAME    Name of desired FNMOC dat file.   (string)            ===
c     FND      Success or failure of search.     (logical)           ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     ADVTIME,  FINDNAME,  REGTIME                                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer day,dtm,dtp,dwk,hour,hwk,month,mwk,year,ywk
      logical     fnd,fndm,fndp
      character*3   idanl,idfct
      character*160 fnamm,fnamp
      character*(*) fname,path
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Make working copy of date information.
c-----------------------------------------------------------------------
c
      dwk = day
      hwk = hour
      mwk = month
      ywk = year
c
c-----------------------------------------------------------------------
c  Look for file at correct time.
c-----------------------------------------------------------------------
c
      call findname (path,idanl,idfct,hour,day,month,year,fname,fnd)
c
c-----------------------------------------------------------------------
c  If not found, look for nearest time.
c-----------------------------------------------------------------------
c
      if (.not.fnd) then
c
c  ---------------------------------------
c  --- Look for nearest advanced time. ---
c  ---------------------------------------
c
         dtp  = 0
         fndp = .false.
         dwk  = day
         hwk  = hour
         mwk  = month
         ywk  = year
c
         do 10 while ( (.not.fndp) .and. (dtp.lt.156) )
            dtp = dtp + 6
            call advtime (6,hwk,dwk,mwk,ywk)
            call findname (path,idanl,idfct,hwk,dwk,mwk,ywk,fnamp,fndp)
  10     continue
c
c  ----------------------------------------
c  --- Look for nearest regressed time. ---
c  ----------------------------------------
c
         dtm  = 0
         fndm = .false.
         dwk  = day
         hwk  = hour
         mwk  = month
         ywk  = year
c
         do 20 while ( (.not.fndm) .and. (dtm.lt.156) )
            dtm = dtm + 6
            call regtime (6,hwk,dwk,mwk,ywk)
            call findname (path,idanl,idfct,hwk,dwk,mwk,ywk,fnamm,fndm)
  20     continue
c
c  ----------------------------
c  --- Use closest success. ---
c  ----------------------------
c
         if (fndp.and.fndm) then
            if (dtp.le.dtm) then
               fname = fnamp
               fnd   = .true.
             else
               fname = fnamm
               fnd   = .true.
            end if
          elseif (fndp) then
            fname = fnamp
            fnd   = .true.
          elseif (fndm) then
            fname = fnamm
            fnd   = .true.
         end if
c
      end if
c
      return
      end
