      subroutine read_mkflx
c
c=======================================================================
c                                                                    ===
c  This routine reads in the data needed to set the FNMOC file names.===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     Common Blocks:                                                 ===
c                                                                    ===
c     /MKFLX_TIM/                                                    ===
c                                                                    ===
c       IDENT   Base identifier for output files.    (string)        ===
c       IDBN    Beginning position of data in IDENT. (integer)       ===
c       IDLN    Length of data in IDENT.             (integer)       ===
c       IDND    Ending position of data in IDENT.    (integer)       ===
c       NDDAY   Ending day.    (1-31)                (integer)       ===
c       NDHR    Ending hour.   (0 or 12)             (integer)       ===
c       NDMON   Ending month.  (1-12)                (integer)       ===
c       NDYR    Ending year.                         (integer)       ===
c       PATH    Basic directory path.                (string)        ===
c       STDAY   Starting day.    (1-31)              (integer)       ===
c       STHR    Starting hour.   (0 or 12)           (integer)       ===
c       STMON   Starting month.  (1-12)              (integer)       ===
c       STYR    Starting year.                       (integer)       ===
c       TINCR   Time increment for                                   ===
c               processing FNMOC data.               (integer; hours)===
c       TSHFT   Time shift to apply to output.       (real; days)    ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
#ifndef knowtime
c     LENGTH                                                         ===
#else
c     ADVTIME,  GETUTC,  JULIAN,  LENGTH                             ===
#endif
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <pconst.h>
#include <mkflx_tim.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer icard
#ifdef knowtime
      integer jdlm,jdnd,jdayoff,lmday,lmhr,lmmin,lmmon,lmsec,
     &        lmwdy,lmyr,mxfcst
      real        day,jflm,jfnd
#endif
      character*1 dum
c
#ifdef knowtime
      parameter (jdayoff=2440000, mxfcst=144)
c
#endif
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Initialize optional identifier.
c-----------------------------------------------------------------------
c
      ident = ' '
c
c-----------------------------------------------------------------------
c  Read input file.
c-----------------------------------------------------------------------
c
      read (5,*) icard
c
      do 10 while (icard.gt.0)
c
c     Read data according to instruction card.
c
         if (icard.eq.1) then
            read (5,*) styr,stmon,stday,sthr
c
          elseif (icard.eq.2) then
            read (5,*) ndyr,ndmon,ndday,ndhr
c
          elseif (icard.eq.3) then
            read (5,*) tincr,tshft
            tshft = tshft*r24
c
          elseif (icard.eq.4) then
            read (5,'(a)') path
c
          elseif (icard.eq.5) then
            read (5,'(a)') ident
c
          else
            read (5,'(a1)') dum
         end if
c
c     Read next instruction card.
c
         read (5,*) icard
c
  10  continue
c
c-----------------------------------------------------------------------
c  Determine length of optional identifier.
c-----------------------------------------------------------------------
c
      call length (ident,idln,idbn,idnd)
c
#ifdef knowtime
c-----------------------------------------------------------------------
c  Limit output time by FNMOC operations.
c-----------------------------------------------------------------------
c
c  Get time (GMT) of most advanced possible FNMOC forecast.
c
      call getutc (lmyr,lmmon,lmday,lmhr,lmmin,lmsec,lmwdy)
      lmhr = (lmhr/12)*12
      call advtime (mxfcst,lmhr,lmday,lmmon,lmyr)
c
c  Limit stopping time by most advanced possible FNMOC forecast.
c
      day = real(lmday) + real(lmhr)*r24
      call julian (day,lmmon,lmyr,jdlm,jflm)
c
      day = real(ndday) + real(ndhr)*r24
      call julian (day,ndmon,ndyr,jdnd,jfnd)
c
      if ( (real(jdnd-jdlm)+(jfnd-jflm)) .gt. 0 ) then
         write (6,20) ndmon,ndday,ndyr,ndhr,lmmon,lmday,lmyr,lmhr
         ndhr  = lmhr
         ndday = lmday
         ndmon = lmmon
         ndyr  = lmyr
      end if
c
#endif
      return
#ifdef knowtime
c
  20  format (/'+++Warning:  READ_MKFLX - cannot process to ',i2,'/',
     &        i2.2,'/',i4,2x,i2,'Z'/13x,'Limiting processing to ',i2,
     &        '/',i2.2,'/',i4,2x,i2,'Z')
c
#endif
      end
