      subroutine set_files (out_unit,nfiles)
c
c=======================================================================
c                                                                    ===
c  This routine creates the list of needed flux files on the fly.    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     OUT_UNIT   Unit number on which to write list.   (integer)     ===
c                                                                    ===
c     Common Blocks:                                                 ===
c                                                                    ===
c     /MKFLX_TIM/                                                    ===
c                                                                    ===
c        NDDAY   Ending day.    (1-31)            (integer)          ===
c        NDHR    Ending hour.   (0 or 12)         (integer)          ===
c        NDMON   Ending month.  (1-12)            (integer)          ===
c        NDYR    Ending year.                     (integer)          ===
c        PATH    Basic directory path.            (string)           ===
c        STDAY   Starting day.    (1-31)          (integer)          ===
c        STHR    Starting hour.   (0 or 12)       (integer)          ===
c        STMON   Starting month.  (1-12)          (integer)          ===
c        STYR    Starting year.                   (integer)          ===
c        TINCR   Time increment for                                  ===
c                processing FNMOC data.           (integer; hours)   ===
c        TSHFT   Time shift to apply to output.   (real; days)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     NFILES     Number of time cycles written.        (integer)     ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     CALDATE,  GETNAME,  JULIAN,  LENGTH,  NO_DIGIT                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <pconst.h>
#include <mkflx_tim.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer dywk,hrwk,iday,imon,iyday,iyr,jdnd,jdayoff,jdst,mnwk,n,
     &        nfiles,nstep,sbgn,send,slen,out_unit,yrwk
      integer no_digit
      logical fnd,found
      real        day,jfnd,jfst
      character*8  tchar
      character*11  dchar
      character*40  fmt
      character*160 atmfl,cldfl,pcpfl,prsfl,rlhfl,sstfl,wndfl
c
      parameter (jdayoff=2440000)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Set loop controls.
c-----------------------------------------------------------------------
c
      day = real(stday) + real(sthr)*r24
      call julian (day,stmon,styr,jdst,jfst)
c
      day = real(ndday) + real(ndhr)*r24
      call julian (day,ndmon,ndyr,jdnd,jfnd)
c
      nstep = nint( (real(jdnd-jdst)+(jfnd-jfst)) / (real(tincr)*r24) )
c
      hrwk = sthr
      dywk = stday
      mnwk = stmon
      yrwk = styr
c
      nfiles = 0
c
      write (fmt,20) no_digit(nstep+1)
c
c-----------------------------------------------------------------------
c  Loop over all times, extracting necessary data file names.
c-----------------------------------------------------------------------
c
      do 10 n = 0, nstep
c
c    Look for data files.
c
         call getname (path,'A01','A01',hrwk,dywk,mnwk,yrwk,prsfl,found)
         call getname (path,'A07','A07',hrwk,dywk,mnwk,yrwk,atmfl,fnd)
         found = found .and. fnd
         call getname (path,'A62','A62',hrwk,dywk,mnwk,yrwk,pcpfl,fnd)
         found = found .and. fnd
         call getname (path,'AWG','AWG',hrwk,dywk,mnwk,yrwk,wndfl,fnd)
         found = found .and. fnd
         call getname (path,'B10','ACI',hrwk,dywk,mnwk,yrwk,sstfl,fnd)
         found = found .and. fnd
         call getname (path,'C34','C34',hrwk,dywk,mnwk,yrwk,rlhfl,fnd)
         found = found .and. fnd
         call getname (path,'Z12','Z12',hrwk,dywk,mnwk,yrwk,cldfl,fnd)
         found = found .and. fnd
c
c    Recore data file names.
c
         if (found) then
c
            day = real(dywk) + real(hrwk)*r24
            call julian (day,mnwk,yrwk,jdnd,jfnd)
            day = real(jdnd-jdayoff) + jfnd + tshft + p5
            call caldate (day,dchar,tchar,iday,imon,iyr,iyday)
            nfiles = nfiles + 1
c
            write (out_unit,fmt) 1,nfiles,'modified Julian day ('//
     &                                    dchar//' at '//tchar//'Z)'
            write (out_unit,30) day
c
            write (out_unit,fmt) 2,nfiles,'surface pressure (mb)'
            call length (prsfl,slen,sbgn,send)
            write (out_unit,40) prsfl(sbgn:send)
c
            write (out_unit,fmt) 3,nfiles,'air temperature (C)'
            call length (atmfl,slen,sbgn,send)
            write (out_unit,40) atmfl(sbgn:send)
c
            write (out_unit,fmt) 4,nfiles,'precipitation (12HR)'
            call length (pcpfl,slen,sbgn,send)
            write (out_unit,40) pcpfl(sbgn:send)
c
            write (out_unit,fmt) 5,nfiles,'wind speed & direction'
            call length (wndfl,slen,sbgn,send)
            write (out_unit,40) wndfl(sbgn:send)
c
            write (out_unit,fmt) 6,nfiles,'sea surface temperature'
            call length (sstfl,slen,sbgn,send)
            write (out_unit,40) sstfl(sbgn:send)
c
            write (out_unit,fmt) 7,nfiles,'relative humidity (%)'
            call length (rlhfl,slen,sbgn,send)
            write (out_unit,40) rlhfl(sbgn:send)
c
            write (out_unit,fmt) 8,nfiles,'cloud cover (10ths)'
            call length (cldfl,slen,sbgn,send)
            write (out_unit,40) cldfl(sbgn:send)
c
         end if
c
c  Increment time.
c
         call advtime (tincr,hrwk,dywk,mnwk,yrwk)
c
  10  continue
c
      return
c
  20  format('(i2.2,3x,',1h','Set ',1h',',i',i2,',',1h',':  ',1h',',a)')
  30  format (f11.3)
  40  format (a)
c
      end
