      subroutine getname (path,fldnam,hour,day,month,year,fname,fcst,
     &                    toff,fnd)
c
c=======================================================================
c                                                                    ===
c  This routine tries to find a FNMOC file corresponding to the      ===
c  given requirements, or the closest available file.                ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     PATH     Basic directory path.                  (string)       ===
c     FLDNAM   Base filename for ALADIN field.        (string)       ===
c     HOUR     Hour  (0, 12) for FNMOC data.          (integer)      ===
c     DAY      Day for FNMOC data.                    (integer)      ===
c     MONTH    Month for FNMOC data.                  (integer)      ===
c     YEAR     Year for FNMOC data.                   (integer)      ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     FNAME    Name of desired FNMOC dat file.   (string)            ===
c     FCST     Length of forecast selected.      (integer; hr)       ===
c     TOFF     Valid time - desired time.        (integer; hr)       ===
c     FND      Success or failure of search.     (logical)           ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     ADVTIME,  FINDNAME,  REGTIME                                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer day,dtm,dtp,dwk,fcst,fcstm,fcstp,hour,hwk,month,mwk,toff,
     &        year,ywk
      logical     fnd,fndm,fndp
      character*160 fnamm,fnamp
      character*(*) fldnam,fname,path
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Make working copy of date information.
c-----------------------------------------------------------------------
c
      dwk = day
      hwk = hour
      mwk = month
      ywk = year
c
c-----------------------------------------------------------------------
c  Look for file at correct time.
c-----------------------------------------------------------------------
c
      toff = 0
c
      call findname (path,fldnam,hour,day,month,year,fname,fcst,fnd)
c
c-----------------------------------------------------------------------
c  If not found, look for nearest time.
c-----------------------------------------------------------------------
c
      if (.not.fnd) then
c
c  ---------------------------------------
c  --- Look for nearest advanced time. ---
c  ---------------------------------------
c
         dtp  = 0
         fndp = .false.
         dwk  = day
         hwk  = hour
         mwk  = month
         ywk  = year
c
         do 10 while ( (.not.fndp) .and. (dtp.lt.48) )
            dtp = dtp + 1
            call advtime (1,hwk,dwk,mwk,ywk)
            call findname (path,fldnam,hwk,dwk,mwk,ywk,fnamp,fcstp,fndp)
  10     continue
c
c  ----------------------------------------
c  --- Look for nearest regressed time. ---
c  ----------------------------------------
c
         dtm  = 0
         fndm = .false.
         dwk  = day
         hwk  = hour
         mwk  = month
         ywk  = year
c
         do 20 while ( (.not.fndm) .and. (dtm.lt.48) )
            dtm = dtm + 1
            call regtime (1,hwk,dwk,mwk,ywk)
            call findname (path,fldnam,hwk,dwk,mwk,ywk,fnamm,fcstm,fndm)
  20     continue
c
c  ----------------------------
c  --- Use closest success. ---
c  ----------------------------
c
         if (fndp.and.fndm) then
            if (dtp.lt.dtm) then
               fname = fnamp
               fcst  = fcstp
               toff  = dtp
               fnd   = .true.
             else if (dtm.lt.dtp) then
               fname = fnamm
               fcst  = fcstm
               toff  = -dtm
               fnd   = .true.
             else if (fcstp.lt.fcstm) then
               fname = fnamp
               fcst  = fcstp
               toff  = dtp
               fnd   = .true.
             else
               fname = fnamm
               fcst  = fcstm
               toff  = -dtm
               fnd   = .true.
            end if
          elseif (fndp) then
            fname = fnamp
            fcst  = fcstp
            toff  = dtp
            fnd   = .true.
          elseif (fndm) then
            fname = fnamm
            fcst  = fcstm
            toff  = -dtm
            fnd   = .true.
         end if
c
      end if
c
      return
      end
