      subroutine advtime (dh,hour,day,month,year)
c
c=======================================================================
c                                                                    ===
c  This routine advances the indicated time by the requested ammount.===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     DH      Ammount to increment times.   (integer; hour)          ===
c     HOUR    Starting hour  (0-23).        (integer)                ===
c     DAY     Starting day  (1-31).         (integer)                ===
c     MONTH   Starting month  (1-12).       (integer)                ===
c     YEAR    Starting year.                (integer)                ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     HOUR    Hour advanced by DH  (0-23).        (integer)          ===
c     DAY     Day advanced by DH  (1-31).         (integer)          ===
c     MONTH   Month advanced by DH  (1-12).       (integer)          ===
c     YEAR    Year advanced by DH.                (integer)          ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     none                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer day,dh,hour,month,year
      integer mndy(12)
c
      save mndy
c
      data mndy /31,28,31,30,31,30,31,31,30,31,30,31/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Increment time by requested amount.
c-----------------------------------------------------------------------
c
      hour = hour + dh
c
c-----------------------------------------------------------------------
c  Make sure time data is valid.  The logic presupposes that the
c  original time data was valid.
c-----------------------------------------------------------------------
c
c  Hour indicator must be less than 24.
c
      if (hour.ge.24) then
         day = day + 1
         hour = hour - 24
      end if
c
c  Reset February for current year.
c
      if ((mod(year,4).ne.0) .or. ((mod(year,100).eq.0).and.
     &    (mod(year,400).ne.0)) ) then
         mndy(2) = 28
       else
         mndy(2) = 29
      end if
c
c  Day number cannot exceed current month allotment.
c
      do 10 while (day.gt.mndy(month))
c
         day = day - mndy(month)
         month = month + 1
c
         if (month.gt.12) then
            year = year + 1
            month = 1
            if ((mod(year,4).ne.0) .or. ((mod(year,100).eq.0).and.
     &          (mod(year,400).ne.0)) ) then
               mndy(2) = 28
             else
               mndy(2) = 29
            end if
         end if
c
  10  continue
c
      return
      end
