      subroutine findname (path,idanl,idfct,hour,day,month,year,fname,
     &                     status)
c
c=======================================================================
c                                                                    ===
c  This routine tries to find a FNMOC file corresponding to the      ===
c  given requirements.                                               ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     PATH     Basic directory path.                  (string)       ===
c     IDANL    Identifier for FNMOC analysis field.   (string)       ===
c     IDFCT    Identifier for FNMOC forecast field.   (string)       ===
c     HOUR     Hour  (0, 12) for FNMOC data.          (integer)      ===
c     DAY      Day for FNMOC data.                    (integer)      ===
c     MONTH    Month for FNMOC data.                  (integer)      ===
c     YEAR     Year for FNMOC data.                   (integer)      ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     FNAME    Name of desired FNMOC dat file.   (string)            ===
c     STATUS   Success or failure of search.     (logical)           ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NEWTIME                                                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer day,dwk,fcst,hour,hwk,i,j,month,mwk,pbn,pnd,pln,sbn,snd,
     &        sln,year,ywk
      logical     status
      character*3 idanl,idfct
      character*3   mnnam(12)
      character*16  zid
      character*(*) fname,path
c
      save mnnam,zid
c
      data mnnam /'Jan','Feb','Mar','Apr','May','Jun',
     &            'Jul','Aug','Sep','Oct','Nov','Dec'/
      data zid /'0123456789ABCDEF'/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Make working copy of date information.
c-----------------------------------------------------------------------
c
      dwk = day
      hwk = hour
      mwk = month
      ywk = year
c
      call length (path,pln,pbn,pnd)
c
c-----------------------------------------------------------------------
c  Look for analysis data.
c-----------------------------------------------------------------------
c
      fcst = 0
      i = fcst/10 + 1
      j = mwk + 1
      write (fname,10) path(pbn:pnd),ywk,mnnam(mwk),idanl,zid(j:j),dwk,
c     &                 10*(hwk/12),zid(i:i),mod(fcst,10)
     &                 hwk,zid(i:i),mod(fcst,10)
  10  format (a,'/',i4,'/',a3,'/',a3,a1,i2.2,i2.2,'.',a1,i1,'T')
c
      call length (fname,sln,sbn,snd)
      inquire (file=fname(sbn:snd), exist=status)
c
c-----------------------------------------------------------------------
c  If no matching analysis fields, look for forecast fields.
c-----------------------------------------------------------------------
c
      do 20 while ((.not.status) .and. (fcst.lt.156))
c
         call newtime (fcst,hwk,dwk,mwk,ywk)
         i = fcst/10 + 1
         j = mwk + 1
         write (fname,10) path(pbn:pnd),ywk,mnnam(mwk),idfct,zid(j:j),
c     &                    dwk,10*(hwk/12),zid(i:i),mod(fcst,10)
     &                    dwk,hwk,zid(i:i),mod(fcst,10)
         call length (fname,sln,sbn,snd)
         inquire (file=fname(sbn:snd), exist=status)
c
  20  continue
c
      return
      end
