/*----------------------------------------------------------------------
 |                                                                     |
 |  getutc_ (year,month,day,hour,minute,second,weekday)                |
 |                                                                     |
 |  This routine passes the current date/time data,in Greenwich Mean   |
 |  time, from C to another language.  When calling from FORTRAN, omit |
 |  the underscore from the name.                                      |
 |                                                                     |
 |  -------                                                            |
 |  Output:                                                            |
 |  -------                                                            |
 |                                                                     |
 |     YEAR      Current year.                    (integer)            |
 |     MONTH     Month of the year.      (1-12)   (integer)            |
 |     DAY       Day of the month.       (1-31)   (integer)            |
 |     HOUR      Hour of the day.        (0-23)   (integer)            |
 |     MINUTE    Minute of the hour.     (0-59)   (integer)            |
 |     SECOND    Second of the minute.   (0-59)   (integer)            |
 |     WEEKDAY   Day of the week code.   (1-7)    (integer)            |
 |                                                                     |
 ----------------------------------------------------------------------*/

/*----------------------------------------------------------------------
  | Define global data.                                                |
  ----------------------------------------------------------------------*/

#include <time.h>

/*----------------------------------------------------------------------
  | Define calling sequence.                                           |
  ----------------------------------------------------------------------*/

void getutc_ (year, month, day, hour, minute, second, weekday)

/*----------------------------------------------------------------------
  | Define local data.                                                 |
  ----------------------------------------------------------------------*/

int (*day), (*hour), (*minute), (*month), (*second), (*weekday), (*year);
{

time_t worksp1;
struct tm worksp;

/*======================================================================
  # Begin executable code.                                             #
  ======================================================================*/

  worksp1 = time();
  worksp = *gmtime(&worksp1);
  
  *year    = worksp.tm_year + 1900;
  *month   = worksp.tm_mon + 1;
  *day     = worksp.tm_mday;
  *hour    = worksp.tm_hour;
  *minute  = worksp.tm_min;
  *second  = worksp.tm_sec;
  *weekday = worksp.tm_wday + 1;

}
