      function no_digit (value)
c
c=======================================================================
c                                                                    ===
c  This function determines the number of digits in the given        ===
c  integer value.                                                    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  VALUE      Number whose "digit count" is desired.  (integer)      ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c  NO_DIGIT   Number of digits in supplied value.     (integer)      ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     none                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer value
      integer no_digit
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      no_digit = int(log10(float(max(abs(value),1)))) + 1 +
     &           max(-sign(1,value),0)
c
      return
      end
