      subroutine regtime (dh,hour,day,month,year)
c
c=======================================================================
c                                                                    ===
c  This routine regresses the indicated time by half a day.          ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     HOUR    Starting hour  (0-23).        (integer)                ===
c     DAY     Starting day  (1-31).         (integer)                ===
c     MONTH   Starting month  (1-12).       (integer)                ===
c     YEAR    Starting year.                (integer)                ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     HOUR    Hour regressed by 12hr  (0-23).        (integer)       ===
c     DAY     Day regressed by 12hr  (1-31).         (integer)       ===
c     MONTH   Month regressed by 12hr  (1-12).       (integer)       ===
c     YEAR    Year regressed by 12hr.                (integer)       ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     none                                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer day,hour,month,year,dh
      integer mndy(12)
c
      save mndy
c
      data mndy /31,28,31,30,31,30,31,31,30,31,30,31/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Decrement time by dh.
c-----------------------------------------------------------------------
c
      hour = hour - dh
c
c-----------------------------------------------------------------------
c  Make sure time data is valid.  The logic presupposes that the
c  original time data was valid.
c-----------------------------------------------------------------------
c
      if (hour.lt.0) then
         day = day - 1
         hour = hour + 24
      end if
c
      if (day.lt.1) then
c
         month = month - 1
c
         if (month.lt.1) then
            year = year - 1
            month = 12
         end if
c
         if ((mod(year,4).ne.0) .or. ((mod(year,100).eq.0).and.
     &       (mod(year,400).ne.0)) ) then
            mndy(2) = 28
          else
            mndy(2) = 29
         end if
c
         day = mndy(month)
c
      end if
c
      return
      end
