      subroutine findname (path,fldnam,hour,day,month,year,fname,
     &                     fcst,status)
c
c=======================================================================
c                                                                    ===
c  This routine tries to find a FNMOC file corresponding to the      ===
c  given requirements.                                               ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     PATH     Basic directory path.                  (string)       ===
c     FLDNAM   Base filename for ALADIN field.        (string)       ===
c     HOUR     Hour  (0, 12) for FNMOC data.          (integer)      ===
c     DAY      Day for FNMOC data.                    (integer)      ===
c     MONTH    Month for FNMOC data.                  (integer)      ===
c     YEAR     Year for FNMOC data.                   (integer)      ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     FNAME    Name of desired FNMOC dat file.   (string)            ===
c     FCST     Length of forecast selected.      (integer; hr)       ===
c     STATUS   Success or failure of search.     (logical)           ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NEWTIME                                                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer day,dwk,fcst,hour,hwk,month,mwk,pbn,pnd,pln,sbn,snd,
     &        sln,year,ywk
      logical     status
      character*3   mnnam(12)
      character*(*) fldnam,fname,path
c
      save mnnam
c
      data mnnam /'Jan','Feb','Mar','Apr','May','Jun',
     &            'Jul','Aug','Sep','Oct','Nov','Dec'/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Make working copy of date information.
c-----------------------------------------------------------------------
c
      dwk = day
      hwk = hour
      mwk = month
      ywk = year
c
      call length (path,pln,pbn,pnd)
c
c-----------------------------------------------------------------------
c  Look for analysis data.
c-----------------------------------------------------------------------
c
      fcst = 0
c      write (fname,10) path(pbn:pnd),ywk,mnnam(mwk),dwk,mod(fcst,24),
c     &                 fldnam,(hwk+fcst)
      write (fname,10) path(pbn:pnd),ywk,mnnam(mwk),dwk,hwk,
     &                 fldnam,fcst
  10  format (a,'/',i4,'/',a3,i2.2,'_',i2.2,'/',a,'_',i2.2,'.dat')
c
      call length (fname,sln,sbn,snd)
      inquire (file=fname(sbn:snd), exist=status)
c
c-----------------------------------------------------------------------
c  If no matching analysis fields, look for forecast fields.
c-----------------------------------------------------------------------
c
      do 20 while ((.not.status) .and. (fcst.lt.48))
c
         call newtime (fcst,hwk,dwk,mwk,ywk)
c         write (fname,10) path(pbn:pnd),ywk,mnnam(mwk),dwk,mod(fcst,24),
c     &                    fldnam,(hwk+fcst)
         write (fname,10) path(pbn:pnd),ywk,mnnam(mwk),dwk,hwk,
     &                    fldnam,fcst
         call length (fname,sln,sbn,snd)
         inquire (file=fname(sbn:snd), exist=status)
c
  20  continue
c
      return
      end
