      program mkaladwind
c
c=======================================================================
c                                                                    ===
c  This program makes the input file for mkaladwind by examining the ===
c  availability of ALADIN wind data files.                           ===
c                                                                    ===
c  Calls:  READ_MKFLX,  SET_FILES,  WRT_FILE                         ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <mkflx_tim.h>
c
c-----------------------------------------------------------------------
c  Define local data
c-----------------------------------------------------------------------
c
      integer nfiles
#ifdef sunfpe
      integer ieeer,my_handler,ieee_handler
      external my_handler
#endif
      data nfiles /0/
c
c=======================================================================
c  Begin executable code
c=======================================================================
c
#ifdef sunfpe
c-----------------------------------------------------------------------
c  Enable floating point error flags.
c-----------------------------------------------------------------------
c
      ieeer = ieee_handler ('set','common',my_handler)
      if (ieeer .ne. 0) write (6,10)
c
#endif
c-----------------------------------------------------------------------
c  Get run parameters.
c-----------------------------------------------------------------------
c
      call read_mkflx
c
c-----------------------------------------------------------------------
c  Determine availability of input files.
c-----------------------------------------------------------------------
c
      if (idln.gt.0) then
         open (23, file='forecast.'//ident(idbn:idnd),
     &         form='formatted', status='unknown')
       else
         open (23, file='forecast.dat', form='formatted', 
     &         status='unknown')
      end if
      write (23,20)
c
      if (idln.gt.0) then
         open (29, file='timeoff.'//ident(idbn:idnd),
     &         form='formatted', status='unknown')
       else
         open (29, file='timeoff.dat', form='formatted', 
     &         status='unknown')
      end if
      write (29,20)
c
      open (19, form='formatted', status='scratch')
c
      call set_files (19,23,29,nfiles)
c
c-----------------------------------------------------------------------
c  Create input file for mk_flux.
c-----------------------------------------------------------------------
c
      if (idln.gt.0) then
         open (13, file='aladwind'//ident(idbn:idnd)//'.in',
     &         form='formatted', status='unknown')
       else
         open (13, file='aladwind.in', form='formatted',
     &         status='unknown')
      end if
      rewind (19)
c
      call wrt_file (19,13,nfiles)
c
c-----------------------------------------------------------------------
c  Close up shop.
c-----------------------------------------------------------------------
c
      close (13)
      close (19)
      close (23)
      close (29)
c
#ifdef sunfpe
 10   format (/'+++ Warning:  ieee_handler cannot set my_handler'/)
#endif
 20   format ('%  time',7x,'wind'/'%ModJulDay',5x,'hr')
c
      end
