      subroutine newtime (fcst,hour,day,month,year)
c
c=======================================================================
c                                                                    ===
c  This routine sets up a new test time for finding FNMOC data.      ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     FCST    Forecast duration.            (integer; hour)          ===
c     HOUR    Starting hour  (0-23).        (integer)                ===
c     DAY     Starting day  (1-31).         (integer)                ===
c     MONTH   Starting month  (1-12).       (integer)                ===
c     YEAR    Starting year.                (integer)                ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     FCST    Forecast duration advanced by 12hr.    (integer; hour) ===
c     HOUR    Hour regressed by 12hr  (0-23).        (integer)       ===
c     DAY     Day regressed by 12hr  (1-31).         (integer)       ===
c     MONTH   Month regressed by 12hr  (1-12).       (integer)       ===
c     YEAR    Year regressed by 12hr.                (integer)       ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     REGTIME                                                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer day,fcst,hour,month,year
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Increment forecast 
c-----------------------------------------------------------------------
c
      fcst = fcst + 1
c
c-----------------------------------------------------------------------
c  Decrement time 
c-----------------------------------------------------------------------
c
      call regtime (1,hour,day,month,year)
c
      return
      end
