      subroutine set_files (out_unit,fcst_unit,toff_unit,nfiles)
c
c=======================================================================
c                                                                    ===
c  This routine creates the list of needed flux files on the fly.    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     OUT_UNIT   Unit number on which to write list.   (integer)     ===
c                                                                    ===
c     Common Blocks:                                                 ===
c                                                                    ===
c     /MKFLX_TIM/                                                    ===
c                                                                    ===
c        NDDAY   Ending day.    (1-31)            (integer)          ===
c        NDHR    Ending hour.   (0 or 12)         (integer)          ===
c        NDMON   Ending month.  (1-12)            (integer)          ===
c        NDYR    Ending year.                     (integer)          ===
c        PATH    Basic directory path.            (string)           ===
c        STDAY   Starting day.    (1-31)          (integer)          ===
c        STHR    Starting hour.   (0 or 12)       (integer)          ===
c        STMON   Starting month.  (1-12)          (integer)          ===
c        STYR    Starting year.                   (integer)          ===
c        TINCR   Time increment for                                  ===
c                processing FNMOC data.           (integer; hours)   ===
c        TSHFT   Time shift to apply to output.   (real; days)       ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     NFILES     Number of time cycles written.        (integer)     ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     CALDATE,  GETNAME,  JULIAN,  LENGTH,  NO_DIGIT                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <pconst.h>
#include <mkflx_tim.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer dywk,hrwk,fcst_unit,iday,imon,iyday,iyr,jdnd,jdayoff,jdst,
     &        mnwk,n,nfiles,nstep,out_unit,sbgn,send,slen,toff_unit,uwfc
     &        ,uwto,vwfc,vwto,yrwk
      integer no_digit
      logical fnd,found
      real        day,jfnd,jfst
      character*8  tchar
      character*11  dchar
      character*40  fmt
      character*160 uwndfl,vwndfl
c
      parameter (jdayoff=2440000)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Set loop controls.
c-----------------------------------------------------------------------
c
      day = real(stday) + real(sthr)*r24
      call julian (day,stmon,styr,jdst,jfst)
c
      day = real(ndday) + real(ndhr)*r24
      call julian (day,ndmon,ndyr,jdnd,jfnd)
c
      nstep = nint( (real(jdnd-jdst)+(jfnd-jfst)) / (real(tincr)*r24) )
c
      hrwk = sthr
      dywk = stday
      mnwk = stmon
      yrwk = styr
c
      nfiles = 0
c
      write (fmt,20) no_digit(nstep+1)
c
c-----------------------------------------------------------------------
c  Loop over all times, extracting necessary data file names.
c-----------------------------------------------------------------------
c
      do 10 n = 0, nstep
c
c    Look for data files.
c
         call getname (path,'CLSVENT_ZONAL',hrwk,dywk,mnwk,yrwk,uwndfl,
     &                 uwfc,uwto,found)
         call getname (path,'CLSVENT_MERIDIEN',hrwk,dywk,mnwk,yrwk,
     &                 vwndfl,vwfc,vwto,fnd)
         found = found .and. fnd
c
c    Record data file names.
c
         if (found) then
c
            day = real(dywk) + real(hrwk)*r24
            call julian (day,mnwk,yrwk,jdnd,jfnd)
            day = real(jdnd-jdayoff) + jfnd + tshft + p5
            call caldate (day,dchar,tchar,iday,imon,iyr,iyday)
            nfiles = nfiles + 1
c
            write (out_unit,fmt) 1,nfiles,'modified Julian day ('//
     &                                    dchar//' at '//tchar//'Z)'
            write (out_unit,30) day
c
            write (out_unit,fmt) 2,nfiles,'zonal wind (m/s)'
            call length (uwndfl,slen,sbgn,send)
            write (out_unit,40) uwndfl(sbgn:send)
c
            write (out_unit,fmt) 3,nfiles,'meridional wind (m/s)'
            call length (vwndfl,slen,sbgn,send)
            write (out_unit,40) vwndfl(sbgn:send)
c
            uwfc = max(uwfc, vwfc)
            write (fcst_unit,50) day,uwfc
c
            if (abs(vwto).gt.abs(uwto)) uwto=vwto
            write (toff_unit,50) day,uwto
c
         end if
c
c  Increment time.
c
         call advtime (tincr,hrwk,dywk,mnwk,yrwk)
c
  10  continue
c
      return
c
  20  format('(i2.2,3x,',1h','Set ',1h',',i',i2,',',1h',':  ',1h',',a)')
  30  format (f11.3)
  40  format (a)
  50  format (f10.3,4x,i3)
c
      end
