      subroutine wrt_file (in_unit,out_unit,nfiles)
c
c=======================================================================
c                                                                    ===
c  This routine creates the input file for make_flux.                ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IN_UNIT    Unit number on which to find list.    (integer)     ===
c     OUT_UNIT   Unit number on which to write file.   (integer)     ===
c     NFILES     Number of time cycles written.        (integer)     ===
c                                                                    ===
c     Common Blocks:                                                 ===
c                                                                    ===
c     /MKFLX_TIM/                                                    ===
c                                                                    ===
c       IDENT   Base identifier for output files.     (string)       ===
c       IDBN    Beginning position of data in IDENT.  (integer)      ===
c       IDLN    Length of data in IDENT.              (integer)      ===
c       IDND    Ending position of data in IDENT.     (integer)      ===
c                                                                    ===
c  ------                                                            ===
c  Calls:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     LENGTH                                                         ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <mkflx_tim.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer in_unit,ios,nfiles,out_unit,sbgn,send,slen
      character*160 line
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Write header.
c-----------------------------------------------------------------------
c
      if (idln.gt.0) then
         write (out_unit,20) 'log.'//ident(idbn:idnd),
     &                       'dat.'//ident(idbn:idnd)//'.wstr',
     &                       nfiles
       else
         write (out_unit,20) 'log','dat.wstr',nfiles
      end if
c
c-----------------------------------------------------------------------
c  Add previously written file list to output.
c-----------------------------------------------------------------------
c
      read (in_unit,30,iostat=ios) line
c
      do 10 while (ios.eq.0)
c
         call length (line,slen,sbgn,send)
         write (out_unit,30) line(sbgn:send)
         read (in_unit,30,iostat=ios) line
c
  10  continue
c
      return
c
  20  format ('1    name of output file for ascii output'/a/
     &        '2    name of output file for wind stress'/a/
     &        '3    number of sets to process'/i10)
  30  format (a)
c
      end
