
function energy (scl,pltlev)
% energy (scl,pltlev)
%
% scl:     window in time (0, 1, or 2)
% pltlev:  vertical level(s) to plot


set_run_parm

date0 = datenum(time0) - 1;
clear time0;


 APEmax = 0.;
 APEmin = -0.;

 KEmax = 0.;
 KEmin = -0.;




if scl==1, SCL='M'; elseif scl==0, SCL='L'; end


for lev = pltlev,
    
     xyfill = get_fill (grdname, zlev_path, lev);

for fig = 1 : 4,

    figAPE = fig;
    figKE = fig + 10;

    figure(figAPE);   clf;
    figure(figKE);   clf;

    subfigno = 0;
    t1 = (fig-1) * 9 + 1;
    t2 = min (tmax, fig * 9);

    for t = [t1:t2],
        subfigno = subfigno+1; 
        if subfigno==4 | subfigno==8, 
	   subfigno = subfigno + 1;
	end


	[APE, KE, mask_ape, mask_ke] = get_energy ...
                (evapath, grdname, zlev_path, t, scl, lev, ncl, aspectR, mask);

	figure(figAPE)
            subplot(3,4,subfigno)
		APE(1,1) = APEmax;
		APE(1,2) = APEmin;
		[jm, im] = size(APE);
	    cont_plt(APE,[1:im],[1:jm],ncl,aspectR, 'y','y', xyfill,mask_ape);
                title(['APE_', SCL, ' (',datestr(t+date0,3),' ', ...
	               datestr(t+date0,7),', ', 'lev=', num2str(lev), ')']);
	    gcfAPE = gcf;

	figure(figKE)
            subplot(3,4,subfigno)
		KE(1,1) = KEmax;
		KE(1,2) = KEmin;
		[jm, im] = size(KE);
	    cont_plt(KE,[1:im],[1:jm],ncl,aspectR, 'y','y', xyfill,mask_ke);
                title(['KE_', SCL, ' (',datestr(t+date0,3),' ', ...
	               datestr(t+date0,7),', ', 'lev=', num2str(lev), ')']);
	    gcfKE = gcf;
     end

     print(gcfAPE, '-depsc', [pltdir, '/APE_', SCL, '_lev', num2str(lev),...
	 			   '_', num2str(fig), '.eps']);
     print(gcfKE, '-depsc', [pltdir, '/KE_', SCL, '_lev', num2str(lev),...
	 			   '_', num2str(fig), '.eps']);

end
end



function [APE, KE, mask_ape, mask_ke] = get_energy ...
	      (evapath, grdname, zlev_path, day, scl, kp, ncl, aspectR, mask)
%
% get_energy (evapath, grdname, zlev_path, day, scl, kp, ncl, aspectR, mask)
%
%
% EVAPATH: path of MS-EVA data
% GRDNAME: name of grids file
% DAY: a string. t number of the directory for processing
%      (Not really the time. For correspondence, check config.h)
% SCL: scale index:  Large=0;  Meso=1; Submeso=2.
% NCL: number of contour lines for the plots (for ref. only).
% ASPECTR:  Aspect Ratio (x:y) for the map.
% MASK: mask ratio.  If set zero, no mask. 
%       Let R_max be the largest value range for the subplots of a figure,
%       and R_mask = MASK * R_max, then 
%       the energetic terms with ranges small than R_mask
%       will be masked. 
%
% For example:
% 
% evapath = '/home/san/mymodel/MS-EVA';
% day = 5;
% grdname = '/home/projects2/AOSN2/Grids/MBay/grids_MBay_cnd05n.nc';
% scl = 1;
% kp = 5;
% ncl = 15;
% aspectR = 1;
% mask = 0.05

nid = netcdf(grdname);
   H(:,:) = nid{'tbath'}(:,:);
   landt(:,:) = nid{'landt'}(:,:);
   im = nid{'imt'}(:);
   jm = nid{'jmt'}(:);
   dxt = nid{'dxt'}(:);		dx = dxt(1) / 1000;		% in km
   dyt = nid{'dyt'}(:);		dy = dyt(2) / 1000;		% in km
close(nid)

    H = abs(H);
    H(find(landt<=0)) = -100;

file_zlev = [zlev_path, '/drho_dz.dat'];
zz = load(file_zlev);
z_lev = zz(:,1);
z_lev = abs(z_lev);


    s2 = 1 : jm;
    s1 = 1 : im;
 

if scl==0,
   sclind = 'L';
     elseif scl==1,
       sclind = 'M';
     else
   sclind = 'S';
end

suffix = ['_', sclind, '_lev', num2str(kp), '.dat'];


dp = [evapath, '/t', num2str(day), '/'];	% "data path"


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

APE = load([dp, 'APE', suffix]);   APE = modf(APE, kp, z_lev, H);
KE  = load([dp, 'KE',  suffix]);   KE  = modf(KE,  kp, z_lev, H);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

APE = APE(s2, s1);
KE  = KE (s2, s1);


%%%%%%%%%%%%%%%%% Find mask_ape and mask_ke %%%%%%%%%%%%%%%%%%%%%%%%
%   APE and KE energetics with ranges small than these limits resp.%
%   will be masked. If set (0, 0), no mask. 			   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
mask_ape = max(APE(:)) - min(APE(:));
mask_ape = mask_ape * mask;

mask_ke = max(KE(:)) - min(KE(:));
mask_ke = mask_ke * mask;
