
function interaction (scl,pltlev,pltrange)
% interaction (scl,pltlev,pltrange)
%
% scl:       window in time (0, 1, or 2)
% pltlev:    vertical level(s) to plot
% pltrange:  Constant range for plotting transfers.
%            If not present or empty, individual ranges
%            are chosen for each panel.

if (nargin<3)
   pltrange = [];
end;

set_run_parm

date0 = datenum(time0) - 1;
clear time0;


% Level 6	(for (Level 2), multiply by 3)
% 
% BCmax = 0.3e-7;		% max & min BC to control the color scale
% BCmin = -1.5e-7;
% 
% BTmax = 0.6e-7;
% BTmin = -3e-7;


 BCmax = 0.05e-7;
 BCmin = -0.2e-7;

 BTmax = 0.1e-7;
 BTmin = -0.05e-7;

if ~isempty(pltrange)
   pltncl = nice(pltrange,2);
end;

if scl==1, SCL='M'; elseif scl==0, SCL='L'; end


for lev = pltlev,
    
     xyfill = get_fill (grdname, zlev_path, lev);

for fig = 1 : 4,

    figBC = fig;
    figBT = fig + 10;

    figure(figBC);   clf;
    figure(figBT);   clf;

    subfigno = 0;
    t1 = (fig-1) * 9 + 1;
    t2 = min (tmax, fig * 9);

    for t = [t1:t2],
        subfigno = subfigno+1; 
        if subfigno==4 | subfigno==8, 
	   subfigno = subfigno + 1;
	end


	[BC, BT, mask_ape, mask_ke] = get_transfer ...
                (evapath, grdname, zlev_path, t, scl, lev, ncl, aspectR, mask);

	figure(figBC)
            subplot(3,4,subfigno)
                if ~isempty(pltrange)
		   BC(1,1) = BCmax;
		   BC(1,2) = BCmin;
                 else
                   pltncl = ncl;
                end;
		[jm, im] = size(BC);
	    cont_plt(BC,[1:im],[1:jm],pltncl,aspectR, 'y','y', xyfill,mask_ape);
                title(['BC_', SCL, ' (',datestr(t+date0,3),' ', ...
	                datestr(t+date0,7),', ', 'lev=', num2str(lev), ')']);
	    gcfBC = gcf;

	figure(figBT)
            subplot(3,4,subfigno)
                if ~isempty(pltrange)
		   BT(1,1) = BTmax;
		   BT(1,2) = BTmin;
                end;
		[jm, im] = size(BT);
	    cont_plt(BT,[1:im],[1:jm],pltncl,aspectR, 'y','y', xyfill,mask_ke);
                title(['BT_', SCL, ' (',datestr(t+date0,3),' ', ...
	                datestr(t+date0,7),', ', 'lev=', num2str(lev), ')']);
	    gcfBT = gcf;
     end

     print(gcfBC, '-depsc', [pltdir, '/BC_', SCL, '_lev', num2str(lev),...
	 			   '_', num2str(fig), '.eps']);
     print(gcfBT, '-depsc', [pltdir, '/BT_', SCL, '_lev', num2str(lev),...
	 			   '_', num2str(fig), '.eps']);

end
end



function [BC, BT, mask_ape, mask_ke] = get_transfer ...
	      (evapath, grdname, zlev_path, day, scl, kp, ncl, aspectR, mask)
%
% get_transfer (evapath, grdname, zlev_path, day, scl, kp, ncl, aspectR, mask)
%
%
% EVAPATH: path of MS-EVA data
% GRDNAME: name of grids file
% DAY: a string. t number of the directory for processing
%      (Not really the time. For correspondence, check config.h)
% SCL: scale index:  Large=0;  Meso=1; Submeso=2.
% NCL: number of contour lines for the plots (for ref. only).
% ASPECTR:  Aspect Ratio (x:y) for the map.
% MASK: mask ratio.  If set zero, no mask. 
%       Let R_max be the largest value range for the subplots of a figure,
%       and R_mask = MASK * R_max, then 
%       the energetic terms with ranges small than R_mask
%       will be masked. 
%
% For example:
% 
% evapath = '/home/san/mymodel/MS-EVA';
% day = 5;
% grdname = '/home/projects2/AOSN2/Grids/MBay/grids_MBay_cnd05n.nc';
% scl = 1;
% kp = 5;
% ncl = 15;
% aspectR = 1;
% mask = 0.05

nid = netcdf(grdname);
   H(:,:) = nid{'tbath'}(:,:);
   landt(:,:) = nid{'landt'}(:,:);
   im = nid{'imt'}(:);
   jm = nid{'jmt'}(:);
   dxt = nid{'dxt'}(:);		dx = dxt(1) / 1000;		% in km
   dyt = nid{'dyt'}(:);		dy = dyt(2) / 1000;		% in km
close(nid)

    H = abs(H);
    H(find(landt<=0)) = -100;

file_zlev = [zlev_path, '/drho_dz.dat'];
zz = load(file_zlev);
z_lev = zz(:,1);
z_lev = abs(z_lev);


    s2 = 1 : jm;
    s1 = 1 : im;
 

if scl==0,
   sclind = 'L';
     elseif scl==1,
       sclind = 'M';
     else
   sclind = 'S';
end

suffix = ['_', sclind, '_lev', num2str(kp), '.dat'];


dp = [evapath, '/t', num2str(day), '/'];	% "data path"


%%%%%%%%%%%%% Appending suffix for the transfer terms %%%%%%%%%%%%%%
%%%%%% naming convention must be the same as that in mseva.f %%%%%%%
    is0 = scl;   is1 = is0 + 1;  is2 = is0 + 2;
    is1 = mod(is1, 3);  is2 = mod(is2, 3);
         app1 = [num2str(is1), num2str(is0)];
         app2 = [num2str(is2), num2str(is0)];
         app3 = [num2str(is1), num2str(is2), num2str(is0)];
         app4 = [num2str(is0), num2str(is0)];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



TA_x1 = load([dp, 'TA_x', app1, suffix]);   TA_x1 = modf(TA_x1, kp, z_lev, H);
TA_x2 = load([dp, 'TA_x', app2, suffix]);   TA_x2 = modf(TA_x2, kp, z_lev, H);
TA_x3 = load([dp, 'TA_x', app3, suffix]);   TA_x3 = modf(TA_x3, kp, z_lev, H);
TA_x4 = load([dp, 'TA_x', app4, suffix]);   TA_x4 = modf(TA_x4, kp, z_lev, H);

TA_y1 = load([dp, 'TA_y', app1, suffix]);   TA_y1 = modf(TA_y1, kp, z_lev, H);
TA_y2 = load([dp, 'TA_y', app2, suffix]);   TA_y2 = modf(TA_y2, kp, z_lev, H);
TA_y3 = load([dp, 'TA_y', app3, suffix]);   TA_y3 = modf(TA_y3, kp, z_lev, H);
TA_y4 = load([dp, 'TA_y', app4, suffix]);   TA_y4 = modf(TA_y4, kp, z_lev, H);

TA_z1 = load([dp, 'TA_z', app1, suffix]);   TA_z1 = modf(TA_z1, kp, z_lev, H);
TA_z2 = load([dp, 'TA_z', app2, suffix]);   TA_z2 = modf(TA_z2, kp, z_lev, H);
TA_z3 = load([dp, 'TA_z', app3, suffix]);   TA_z3 = modf(TA_z3, kp, z_lev, H);
TA_z4 = load([dp, 'TA_z', app4, suffix]);   TA_z4 = modf(TA_z4, kp, z_lev, H);

SA1 = load([dp, 'SA', app1, suffix]);	SA1 = modf(SA1, kp, z_lev, H);
SA2 = load([dp, 'SA', app2, suffix]);	SA2 = modf(SA2, kp, z_lev, H);
SA3 = load([dp, 'SA', app3, suffix]);	SA3 = modf(SA3, kp, z_lev, H);
SA4 = load([dp, 'SA', app4, suffix]);	SA4 = modf(SA4, kp, z_lev, H);

% FA_z = load([dp, 'FA_z', suffix]); 	FA_z = modf(FA_z, kp, z_lev, H);


        TA_x = TA_x1 + TA_x2 + TA_x3 + TA_x4;
        TA_y = TA_y1 + TA_y2 + TA_y3 + TA_y4;
        TA_z = TA_z1 + TA_z2 + TA_z3 + TA_z4;

fac = 1;

TA_x = TA_x(s2, s1) * fac;
TA_y = TA_y(s2, s1) * fac;
TA_z = TA_z(s2, s1) * fac;

TA_h = TA_x + TA_y;
SA   = SA1 + SA2 + SA3 + SA4;	      SA = SA(s2, s1);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

TK_x1 = load([dp, 'TK_x', app1, suffix]);   TK_x1 = modf(TK_x1, kp, z_lev, H);
TK_x2 = load([dp, 'TK_x', app2, suffix]);   TK_x2 = modf(TK_x2, kp, z_lev, H);
TK_x3 = load([dp, 'TK_x', app3, suffix]);   TK_x3 = modf(TK_x3, kp, z_lev, H);
TK_x4 = load([dp, 'TK_x', app4, suffix]);   TK_x4 = modf(TK_x4, kp, z_lev, H);

TK_y1 = load([dp, 'TK_y', app1, suffix]);   TK_y1 = modf(TK_y1, kp, z_lev, H);
TK_y2 = load([dp, 'TK_y', app2, suffix]);   TK_y2 = modf(TK_y2, kp, z_lev, H);
TK_y3 = load([dp, 'TK_y', app3, suffix]);   TK_y3 = modf(TK_y3, kp, z_lev, H);
TK_y4 = load([dp, 'TK_y', app4, suffix]);   TK_y4 = modf(TK_y4, kp, z_lev, H);

TK_z1 = load([dp, 'TK_z', app1, suffix]);   TK_z1 = modf(TK_z1, kp, z_lev, H);
TK_z2 = load([dp, 'TK_z', app2, suffix]);   TK_z2 = modf(TK_z2, kp, z_lev, H);
TK_z3 = load([dp, 'TK_z', app3, suffix]);   TK_z3 = modf(TK_z3, kp, z_lev, H);
TK_z4 = load([dp, 'TK_z', app4, suffix]);   TK_z4 = modf(TK_z4, kp, z_lev, H);

% FK_z = load([dp, 'FK_z', suffix]);    FK_z = modf(FK_z, kp, z_lev, H);


        TK_x = TK_x1 + TK_x2 + TK_x3 + TK_x4;
        TK_y = TK_y1 + TK_y2 + TK_y3 + TK_y4;
        TK_z = TK_z1 + TK_z2 + TK_z3 + TK_z4;

fac = 1;

TK_x = TK_x(s2, s1) * fac;
TK_y = TK_y(s2, s1) * fac;
TK_z = TK_z(s2, s1) * fac;

TK_h = TK_x + TK_y;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if scl==1,	% meso-scale
   BC = TA_x2 + TA_y2 + TA_z2 + SA2;  
   BT = TK_x2 + TK_y2 + TK_z2;     	
      elseif scl==0,
         BC = TA_x1 + TA_y1 + TA_z1 + SA1;
         BT = TK_x1 + TK_y1 + TK_z1;
      else
   fprintf('Error: Plz set scl = 0 & 1 only for now.\n');
   break;
end

BT = BT(s2, s1);
BC = BC(s2, s1);


%%%%%%%%%%%%%%%%% Find mask_ape and mask_ke %%%%%%%%%%%%%%%%%%%%%%%%
%   APE and KE energetics with ranges small than these limits resp.%
%   will be masked. If set (0, 0), no mask. 			   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
    ape_range(1) = max(TA_x(:)) - min(TA_x(:));
    ape_range(2) = max(TA_y(:)) - min(TA_y(:));
    ape_range(3) = max(TA_z(:)) - min(TA_z(:));
    ape_range(4) = max(BC(:))   - min(BC(:));
mask_ape = max(ape_range);
mask_ape = mask_ape * mask;

    ke_range(1) = max(TK_x(:)) - min(TK_x(:));
    ke_range(2) = max(TK_y(:)) - min(TK_y(:));
    ke_range(3) = max(TK_z(:)) - min(TK_z(:));
    ke_range(4) = max(BT(:))   - min(BT(:));
mask_ke = max(ke_range);
mask_ke = mask_ke * mask;
