
  function d = truncate(f, n)
%
% truncate(f, n) 
% truncate f at the nth digit.
%
% On input:
%    f: an arbitray number (integer or fraction). 
%    n: the digit position. It corresponds to the nth power of 10. 
%       e.g., 0 corresponds to the first integer digit, and -1 
%	to the first fraction digit.
%
% On return:
%    the truncated number.
%
% Also see: digit

      if floor(n) ~= n, 
         fprintf('Error: N must be an integer.');
         break;
      end

	
      sgnd = ones(size(f));
      negindx = find(f < 0);
      sgnd(negindx) = -1;


      f = abs(f);

      f1 = f / 10^n;
      d = floor(f1);
      d = d * 10^n .* sgnd;

