function velo

warning off

grdfile = '/data/projects2/AOSN2/Grids/MBay/grids_MBay_cnd05n.nc';
work_dir = 'work2';

nid = netcdf(grdfile);
landt(:,:) = nid{'landt'}(:,:);
depth(:,:) = nid{'tbath'}(:,:);
close(nid)

depth = abs(depth);
depth(find(landt==0)) = -999;


for day = 1:32,
    offset = 5;
    calendar_day = ['AUG ', num2str(day + offset)];
    if (day+offset > 31),  calendar_day = ['SEP ', num2str(day+offset-31)]; end
for lev = [2, 6, 12, 20],
figure(1)
clf

	fac = 0.4;
	if lev>6, fac=0.6; end
 	if lev>12, fac=1.5; end

subplot(2,3,1)
    velo_plt(-1, day, calendar_day, lev, fac, depth, work_dir)
subplot(2,3,2)
    velo_plt(0, day, calendar_day, lev, fac, depth, work_dir)
subplot(2,3,3)
    velo_plt(1, day, calendar_day, lev, fac, depth, work_dir)
print(gcf, '-depsc', ...
       		    ['../plots/', work_dir, '/velo/day', num2str(day), ...
     		     '_lev', num2str(lev), '.eps']);

print(gcf, '-djpeg', ...
    		    ['../plots/', work_dir, '/velo/day', num2str(day),...
		     '_lev', num2str(lev), '.jpg']);

end
end


function velo_plt(win, day, calendar_day, lev, fac, depth, work_dir)

levs = load ('../profile/stdlvls.dat');
DIR =  ['../', work_dir, '/Data-mwt/t', num2str(day)];

scl = '';
if win == 0, scl = '_bar'; end
if win == 1, scl = '_prime'; end
if win == 2, scl = '_dprime'; end

u = load([DIR, '/u', scl, '_lev', num2str(lev), '.dat']);
v = load([DIR, '/v', scl, '_lev', num2str(lev), '.dat']);

[m,n] = size(u);

	u = u * 100;		% convert to units in cm/s
	v = v * 100;

hold on
for j = 1 :4 : n,
   for i = 1 : 4 : m,
	if depth(i,j) >= levs(lev),
	   xp = j + u(i,j) * fac;
	   yp = i + v(i,j) * fac;
           vector(j, i, xp, yp, 1, 25);
	end
   end
end


	leng = 25; 
	if lev>6, leng=20; end
	if lev>12, leng=10; end
	
	   x0 = 65;
	   y0 = 15;
	   xp = x0 + leng * fac;
	   yp = y0 +  0 * fac;
	vector(x0, y0, xp, yp, 1, 25)
	text(x0-3,y0-5, [num2str(leng), ' cm/s'], 'FontSize', 9)


hold off

axis ([0 84 0 97])
set(gca, 'Box', 'on')

if win >= 0,
   title([calendar_day, ',   WIN ', num2str(win)]);
      else
   title([calendar_day, ', ', num2str(levs(lev)), ' m']);
end
   

