function interpo_lin

msevahome = '/data2/AOSN2/PE/2005/May31/PJH02/MSEVA/';
stdlvlfile = [msevahome,'pressure/mean_file/stdlvls.dat'];
peinfile   = [msevahome,'pressure/pe_out_3hr.nc'];
clear msevahome

peoutfile  = 'pe_out_3hrflat.nc';

grdfile = '/data/projects2/AOSN2/Grids/MBay/grids_MBay_cnd06.nc';

nseg = 13;	% nseg is num of segments for the NM-pt series.
		% (extraction of too long a signal from an
		%  netcdf file takes a huge amount of time)
                % NSEG=NM -> read 1 time level at a time.
                % NSEG must evenly divide NM.

%-------------------------------------------------------------------------------
% Create output PE file.  Get needed dimensions.
%-------------------------------------------------------------------------------

eval (['!/bin/cp -f ',peinfile,' ',peoutfile,]);

clear peinfile;

nid = netcdf (peoutfile,'write');

im = length(nid('tlon'));
jm = length(nid('tlat'));
km = length(nid('outlev'));
nm = length(nid('time'));

%-------------------------------------------------------------------------------
%  Interpolate fields.
%-------------------------------------------------------------------------------



zr = load(stdlvlfile);
z_lev = zr(:,1);	clear zr;
 

nid0 = netcdf(grdfile);
dzt = nid0{'dzt'}(:,:,:);
dzv = nid0{'dzv'}(:,:,:);
close(nid0);



  process('dena', nid, dzt, 1, im, jm, km, nm, z_lev, nseg);
  process('temp', nid, dzt, 1, im, jm, km, nm, z_lev, nseg);
  process('wvzt', nid, dzt, 1, im, jm, km, nm, z_lev, nseg);
  process('wvzv', nid, dzv, 1, im, jm, km, nm, z_lev, nseg);
  process('vtot', nid, dzv, 2, im, jm, km, nm, z_lev, nseg);
  process('salt', nid, dzt, 1, im, jm, km, nm, z_lev, nseg);

close(nid)


%%% Test %%%
%cd data
%nid0 = netcdf('/data2/AOSN2/san/dataset/pressure/data/pe_out_3hr.nc');
%temp0(:,:) = nid0{'temp'}(10, :, 30, :);
%close(nid0);
%nid1 = netcdf('pe_out_interpo2level.nc');
%temp1(:,:) = nid1{'temp'}(10, :, 30, :);
%close(nid1);
%	figure(10)
%	pcolor(temp0')
%	axis ij
%	colorbar
%	shading interp
%	title('original')
%
%	figure(11)
%	pcolor(temp1')
%	axis ij
%	colorbar
%	shading interp
%	title('modified')
%%%%%%%%%%%%





%%%%%%%%% Process FLD %%%%%%%%%%
%% comps: No. of components of that field (2 for vtot, and 1 for all others)%%
%
  function process(fldnam, nid, dz, comps, im, jm, km, nm, z_lev, nseg)
%
  if fldnam == 'wvzt' | fldnam == 'wvzv', 
     vert = 'y';
        else
     vert = 'n';
  end

for i = 1 : im,
  fld = fld_xtr(fldnam, i, nid, comps, im, jm, km, nm, nseg);
  fld_new = interpo(fld, vert, i, comps, im, jm, km, nm, dz, z_lev);
  fld_write(fldnam, fld_new, i, nid, comps, im, jm, km, nm, nseg);
end



%%%%%%%%%%% Interpolation of FLD onto z_lev and renamed FLD_NEW %%%%%%%%%%%%%
%
  function fld_new = interpo(fld, vert, i, comps,im,jm,km,nm,dz,z_lev)
%
%	vert:  char var, 'y' if processing vertical velo.
%	dz:    3-D vertical grid line spacing
%       z_lev: pre-set flat z-levels onto which fields are interpolated.
%	       changed into zzz when vert='y'.
%       z_grd: grid z-levels
% 

fld_new = fld;

zzz = z_lev;

   if vert == 'y',
      dz_lev(1) = z_lev(1) * 2;
      for k = 2:km,
          dz_lev(k) = z_lev(k) - sum(dz_lev(1:k-1));
          dz_lev(k) = dz_lev(k) * 2;
      end

      for k = 1 : km,
      zzz(k) = z_lev(k) + dz_lev(k) / 2.;
      end
   end



for j = 1 : jm,

  if vert == 'y',
     for k = 1 : km
     z_grd(k) = sum(dz(j,i,1:k));
     end
  else
     for k = 1 : km
     z_grd(k) = sum(dz(j,i,1:k)) - dz(j,i,k) / 2;
     end
  end



   fld_new(1:nm, j, 1, 1, 1:comps) = fld(1:nm, j, 1, 1, 1:comps);

   for k = 2 : km,
     if zzz(k) > z_grd(km),
       fld_new(1:nm, j, 1, k, 1:comps) = fld(1:nm, j, 1, km, 1:comps);
     else
       k22 = find (z_grd >= zzz(k));
       k2 = k22(1);
       k1 = k2 - 1;
       fld_new(1:nm, j, 1, k, 1:comps) = fld(1:nm, j, 1, k1, 1:comps) + ...
            (zzz(k) - z_grd(k1)) / (z_grd(k2) - z_grd(k1)) * ...
            (fld(1:nm, j, 1, k2, 1:comps) - fld(1:nm, j, 1, k1, 1:comps));
     end
   end

end





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function fld = fld_xtr(fldnam, i, nid, comps, im, jm, km, nm, nseg)
dn = nm / nseg;

for seg = 1 : nseg,
    n0 = (seg - 1) * dn + 1;
    n1 = seg * dn;
    fld(n0:n1, 1:jm, 1, 1:km, 1:comps) = ...
		nid{fldnam}(n0:n1, 1:jm, i, 1:km, 1:comps);
end


function fld_write(fldnam, fld, i, nid, comps, im, jm, km, nm, nseg)
dn = nm / nseg; 

for seg = 1 : nseg, 
    n0 = (seg - 1) * dn + 1; 
    n1 = seg * dn; 
    nid{fldnam}(n0:n1, 1:jm, i, 1:km, 1:comps) = ...
		fld(n0:n1, 1:jm, 1, 1:km, 1:comps); 
    redef(nid);
end 

