% Add pressure to the output. 
% pressure replaces salt in the nc file.

presfile = 'pres.dat';
peinfile = '/data2/AOSN2/PE/2005/May31/PJH02/pe_sml_out.nc';

peoutfile = 'pe_out_3hr.nc';

%-------------------------------------------------------------------------------
% Create output PE file.  Get needed dimensions.
%-------------------------------------------------------------------------------

eval (['!/bin/cp -f ',peinfile,' ',peoutfile,]);

clear peinfile;

ncid = netcdf (peoutfile,'write');


im = length(ncid('tlon'));
jm = length(ncid('tlat'));
km = length(ncid('outlev'));
nm = length(ncid('time'));

%-------------------------------------------------------------------------------
% Overwrite salinity with pressure.
%-------------------------------------------------------------------------------

fid = fopen(presfile,  'r');

for nt = 1 : nm;
for k  = 1 : km,
       [p0, count] = fread(fid, [im+2,jm], 'float32');	  
			%
			% Be aware of the shape im+2!  This works only
			% for an unformatted file generated as follows:
			%     do nt=1:nm, do k=1:km, do j=1:jm
			%        write(1) (p(k,i,j,nt), i=1,im)
			%     enddo, enddo, enddo
			%
        p0 = p0(2:im+1, 1:jm)';
        ncid{'salt'}(nt,:,:,k) = p0;
        clear p0;
end
end
fclose(fid);

close(ncid)
